/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.areashopaddon;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collection;
import java.util.logging.Level;
import me.wiefferink.areashop.commands.CommandAreaShop;
import me.wiefferink.areashop.libraries.inject.Inject;
import me.wiefferink.areashop.managers.IFileManager;
import me.wiefferink.areashop.regions.RentRegion;
import net.onestorm.plugins.areashopaddon.AreaShopAddon;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class ClearAllCommand
extends CommandAreaShop {
    private static final String COMMAND_START = "areashop clearall";
    private final AreaShopAddon addon;
    private final IFileManager fileManager;

    @Inject
    public ClearAllCommand(AreaShopAddon addon) {
        this.addon = addon;
        this.fileManager = addon.getAreaShop().getFileManager();
    }

    public String getCommandStart() {
        return COMMAND_START;
    }

    public String getHelp(CommandSender sender) {
        if (!sender.hasPermission("areashop.clearall")) {
            return null;
        }
        return "help-clearall";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CommandSender sender, String[] strings) {
        if (!sender.hasPermission("areashop.clearall")) {
            this.addon.message(sender, "clearall-noPermission", new Object[0]);
            return;
        }
        Collection rentRegions = this.fileManager.getRents();
        if (rentRegions.isEmpty()) {
            this.addon.message(sender, "clearall-noRentRegions", new Object[0]);
            return;
        }
        int size = rentRegions.size();
        int counter = 0;
        for (RentRegion rentRegion : this.fileManager.getRents()) {
            if (rentRegion.isRented()) {
                rentRegion.unRent(false, (CommandSender)Bukkit.getConsoleSender());
            }
            ProtectedRegion worldGuardRegion = rentRegion.getRegion();
            BukkitWorld worldEditWorld = new BukkitWorld(rentRegion.getWorld());
            Polygonal2DRegion worldEditRegion = new Polygonal2DRegion((World)worldEditWorld, worldGuardRegion.getPoints(), worldGuardRegion.getMinimumPoint().y(), worldGuardRegion.getMaximumPoint().y());
            try {
                EditSession editSession = WorldEdit.getInstance().newEditSession((World)worldEditWorld);
                try {
                    editSession.setBlocks((Region)worldEditRegion, (Pattern)BlockTypes.AIR);
                }
                finally {
                    if (editSession == null) continue;
                    editSession.close();
                }
            }
            catch (MaxChangedBlocksException e) {
                this.addon.getLogger().log(Level.WARNING, "Region is to big to clear: " + worldGuardRegion.getId(), e);
            }
            finally {
                if (size != ++counter) continue;
                this.addon.message(sender, "clearall-success", new Object[0]);
            }
        }
    }
}

