/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.areashopaddon.command;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import me.wiefferink.areashop.managers.IFileManager;
import me.wiefferink.areashop.regions.RentRegion;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.onestorm.plugins.areashopaddon.AreaShopAddon;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.jetbrains.annotations.NotNull;

public class ClearAllCommand
extends BukkitCommand {
    private static final String COMMAND_NAME = "areashopclearall";
    private static final List<String> COMMAND_ALIASES = List.of("asclearall", "cellclearall");
    private static final String COMMAND_PERMISSION = "areashopaddon.command.clearall";
    private final AreaShopAddon addon;
    private final IFileManager fileManager;

    public ClearAllCommand(AreaShopAddon addon) {
        super(COMMAND_NAME);
        this.addon = addon;
        this.fileManager = addon.getAreaShop().getFileManager();
        this.setAliases(COMMAND_ALIASES);
        this.setPermission(COMMAND_PERMISSION);
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] arguments) {
        this.handleCommand(sender);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCommand(CommandSender sender) {
        Collection rentRegions = this.fileManager.getRents();
        if (rentRegions.isEmpty()) {
            sender.sendMessage((Component)Component.text((String)"There are no (rentable) regions to clear.", (TextColor)NamedTextColor.RED));
            return;
        }
        int size = rentRegions.size();
        int counter = 0;
        for (RentRegion rentRegion : this.fileManager.getRents()) {
            if (rentRegion.isRented()) {
                rentRegion.unRent(false, (CommandSender)Bukkit.getConsoleSender());
            }
            ProtectedRegion worldGuardRegion = rentRegion.getRegion();
            BukkitWorld worldEditWorld = new BukkitWorld(rentRegion.getWorld());
            Polygonal2DRegion worldEditRegion = new Polygonal2DRegion((World)worldEditWorld, worldGuardRegion.getPoints(), worldGuardRegion.getMinimumPoint().y(), worldGuardRegion.getMaximumPoint().y());
            try {
                EditSession editSession = WorldEdit.getInstance().newEditSession((World)worldEditWorld);
                try {
                    editSession.setBlocks((Region)worldEditRegion, (Pattern)BlockTypes.AIR);
                }
                finally {
                    if (editSession == null) continue;
                    editSession.close();
                }
            }
            catch (MaxChangedBlocksException e) {
                this.addon.getLogger().log(Level.WARNING, "Region is to big to clear: " + worldGuardRegion.getId(), e);
            }
            finally {
                if (size != ++counter) continue;
                sender.sendMessage((Component)Component.text((String)"Cleared all (rentable) regions.", (TextColor)NamedTextColor.GREEN));
            }
        }
    }
}

