/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.action.implementation;

import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.onestorm.library.action.Action;
import net.onestorm.library.action.implementation.MessageAction;
import net.onestorm.library.common.context.BuildContext;
import net.onestorm.library.common.context.StorageBuildContext;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.common.factory.Builder;
import net.onestorm.library.storage.StorageMap;

public class MessageActionBuilder
implements Builder<Action> {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final String MESSAGE_NAME = "message";

    @Override
    public String getName() {
        return MESSAGE_NAME;
    }

    @Override
    public Action build(BuildContext context) {
        if (!(context instanceof StorageBuildContext)) {
            throw new BuildException("UserContext is not an instance of StorageBuildContext.");
        }
        StorageBuildContext storageContext = (StorageBuildContext)context;
        StorageMap storage = storageContext.getStorage();
        Optional<String> optionalMessage = storage.getString(MESSAGE_NAME);
        if (optionalMessage.isEmpty()) {
            throw new IllegalArgumentException("Missing \"message\" key in configuration");
        }
        Component message = MINI_MESSAGE.deserialize((Object)optionalMessage.get());
        return new MessageAction(message);
    }
}

