/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.action;

import net.kyori.adventure.sound.Sound;
import net.onestorm.library.paper.action.PaperAction;
import net.onestorm.library.paper.context.PlayerContext;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PlaySoundAction
extends PaperAction {
    private final Server server;
    private final String scope;
    private final Sound sound;

    public PlaySoundAction(Server server, String scope, Sound sound) {
        this.server = server;
        this.scope = scope;
        this.sound = sound;
    }

    @Override
    public void execute(PlayerContext context) {
        Player player = context.getPlayer();
        World world = player.getWorld();
        Location location = player.getLocation();
        switch (this.scope) {
            case "server": {
                this.server.playSound(this.sound, Sound.Emitter.self());
                break;
            }
            case "world": {
                world.playSound(this.sound, Sound.Emitter.self());
                break;
            }
            case "location": {
                world.playSound(this.sound, location.getX(), location.getY(), location.getZ());
                break;
            }
            default: {
                player.playSound(this.sound, Sound.Emitter.self());
            }
        }
    }
}

