/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.storage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.onestorm.library.storage.MemoryStorageMap;
import net.onestorm.library.storage.Storage;
import net.onestorm.library.storage.StorageElement;
import net.onestorm.library.storage.StorageList;
import net.onestorm.library.storage.StorageMap;
import org.jetbrains.annotations.NotNull;

public class MemoryStorageList
implements StorageList {
    private final List<Object> list = new ArrayList<Object>();
    private final Storage root;
    private final StorageElement parent;

    public MemoryStorageList() {
        if (!(this instanceof Storage)) {
            throw new IllegalStateException("Not a root storage object");
        }
        this.root = (Storage)((Object)this);
        this.parent = null;
    }

    public MemoryStorageList(StorageElement parent) {
        this.root = parent.getRoot();
        this.parent = parent;
    }

    @Override
    public Storage getRoot() {
        return this.root;
    }

    @Override
    public StorageElement getParent() {
        return this.parent;
    }

    @Override
    public void add(Object value) {
        this.list.add(value);
    }

    @Override
    public StorageMap addMap() {
        MemoryStorageMap result = new MemoryStorageMap(this);
        this.list.add(result);
        return result;
    }

    @Override
    public StorageList addList() {
        MemoryStorageList result = new MemoryStorageList(this);
        this.list.add(result);
        return result;
    }

    @Override
    public boolean remove(Object value) {
        return this.list.remove(value);
    }

    @Override
    public boolean removeIf(Predicate<Object> filter) {
        return this.list.removeIf(filter);
    }

    @Override
    @NotNull
    public Iterator<Object> iterator() {
        return this.list.iterator();
    }
}

