/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.menu.element.build;

import java.util.ArrayList;
import java.util.List;
import net.onestorm.library.common.context.BuildContext;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.common.factory.Builder;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.menu.element.IdentifiableElement;
import net.onestorm.library.menu.element.PrioritizableElement;
import net.onestorm.library.menu.element.build.context.ElementBuildContext;
import net.onestorm.library.storage.StorageMap;

public abstract class AbstractElementBuilder
implements Builder<Element> {
    protected static final int DEFAULT_WIDTH = 1;
    protected static final int DEFAULT_HEIGHT = 1;

    @Override
    public Element build(BuildContext context) {
        if (!(context instanceof ElementBuildContext)) {
            throw new BuildException("BuildContext is not an instance of ElementBuildContext.");
        }
        ElementBuildContext elementContext = (ElementBuildContext)context;
        StorageMap storage = elementContext.getStorage();
        Menu menu = elementContext.getMenu();
        String name = this.getName();
        int x = storage.getInteger("x").orElseThrow(() -> new BuildException("Missing \"x\" key in storage while building: " + name));
        int y = storage.getInteger("y").orElseThrow(() -> new BuildException("Missing \"y\" key in storage while building: " + name));
        int width = storage.getInteger("width").orElse(1);
        int height = storage.getInteger("height").orElse(1);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int indexY = y; indexY < y + height; ++indexY) {
            for (int indexX = x; indexX < x + width; ++indexX) {
                slots.add(indexY * menu.getWidth() + indexX);
            }
        }
        Element element = this.createElement(storage, menu, slots);
        if (element instanceof IdentifiableElement) {
            IdentifiableElement identifiable = (IdentifiableElement)((Object)element);
            storage.getString("identifier").ifPresent(identifiable::setIdentifier);
        }
        if (element instanceof PrioritizableElement) {
            PrioritizableElement prioritizable = (PrioritizableElement)((Object)element);
            storage.getInteger("priority").ifPresent(prioritizable::setPriority);
        }
        return element;
    }

    protected abstract Element createElement(StorageMap var1, Menu var2, List<Integer> var3);
}

