/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.onestorm.library.message.MessageBuilder;
import org.jetbrains.annotations.NotNull;

public class MessageBuilderImpl
implements MessageBuilder {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private String message;
    private String defaultMessage;
    private boolean allowDisabled = false;
    private final Collection<TagResolver> tagResolvers = new ArrayList<TagResolver>();

    public MessageBuilderImpl() {
    }

    public MessageBuilderImpl(String message) {
        this.message = message;
    }

    @Override
    public MessageBuilder withMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public MessageBuilder withDefault(String message) {
        this.defaultMessage = message;
        return this;
    }

    @Override
    public MessageBuilder allowDisabled() {
        this.allowDisabled = true;
        return this;
    }

    @Override
    public MessageBuilder disallowDisabled() {
        this.allowDisabled = false;
        return this;
    }

    @Override
    public MessageBuilder withTagResolver(TagResolver resolver) {
        this.tagResolvers.add(resolver);
        return this;
    }

    @Override
    public MessageBuilder withPlaceholder(@TagPattern String key, String value) {
        return this.withPlaceholder(key, (Component)Component.text((String)value));
    }

    @Override
    public MessageBuilder withPlaceholder(@TagPattern String key, Component value) {
        this.tagResolvers.add((TagResolver)Placeholder.component((String)key, (ComponentLike)value));
        return this;
    }

    @Override
    public Component build() {
        String finalMessage = this.message;
        if (this.message == null) {
            if (this.defaultMessage == null) {
                throw new IllegalArgumentException("message and defaultMessage are null");
            }
            finalMessage = this.defaultMessage;
        } else if (this.allowDisabled && this.message.equalsIgnoreCase("none")) {
            throw new IllegalArgumentException("cannot build an disabled message");
        }
        return MINI_MESSAGE.deserialize(finalMessage, TagResolver.resolver(this.tagResolvers));
    }

    @Override
    public Optional<Component> tryBuild() {
        String finalMessage = this.message;
        if (this.message == null) {
            if (this.defaultMessage == null) {
                return Optional.empty();
            }
            finalMessage = this.defaultMessage;
        } else if (this.allowDisabled && this.message.equalsIgnoreCase("none")) {
            return Optional.empty();
        }
        Component component = MINI_MESSAGE.deserialize(finalMessage, TagResolver.resolver(this.tagResolvers));
        return Optional.of(component);
    }

    @NotNull
    public Component asComponent() {
        return this.build();
    }
}

