/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.menu.util;

import java.util.function.Supplier;
import net.onestorm.library.common.factory.Builder;
import net.onestorm.library.common.factory.Factory;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.build.AbstractMenuBuilder;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.storage.StorageMap;

public class MenuUtil {
    private MenuUtil() {
    }

    public static Builder<Menu> builder(Factory<Element> elementFactory, String name, Supplier<Menu> menuSupplier) {
        return new SupplierBasedMenuBuilder(elementFactory, name, menuSupplier);
    }

    private static class SupplierBasedMenuBuilder
    extends AbstractMenuBuilder {
        private final String name;
        private final Supplier<Menu> menuSupplier;

        public SupplierBasedMenuBuilder(Factory<Element> elementFactory, String name, Supplier<Menu> menuSupplier) {
            super(elementFactory);
            this.name = name;
            this.menuSupplier = menuSupplier;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        protected Menu createMenu(StorageMap configuration) {
            return this.menuSupplier.get();
        }
    }
}

