/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.action;

import java.util.Locale;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.onestorm.library.action.Action;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.common.factory.Builder;
import net.onestorm.library.common.factory.context.BuildContext;
import net.onestorm.library.common.factory.context.StorageBuildContext;
import net.onestorm.library.paper.action.PlaySoundAction;
import net.onestorm.library.storage.StorageMap;
import org.bukkit.Server;

public class PlaySoundActionBuilder
implements Builder<Action> {
    private static final String BUILDER_NAME = "play-sound";
    private final Server server;

    public PlaySoundActionBuilder(Server server) {
        this.server = server;
    }

    @Override
    public String getName() {
        return BUILDER_NAME;
    }

    @Override
    public Action build(BuildContext context) {
        Sound.Source source;
        if (!(context instanceof StorageBuildContext)) {
            throw new BuildException("Context is not an instance of StorageBuildContext.");
        }
        StorageBuildContext storageContext = (StorageBuildContext)context;
        StorageMap storage = storageContext.getStorage();
        Optional<String> optionalSound = storage.getString("sound");
        if (optionalSound.isEmpty()) {
            throw new IllegalArgumentException("Missing \"sound\" key in configuration");
        }
        String scope = storage.getString("scope").orElse("player");
        String namespace = storage.getString("namespace").orElse("minecraft");
        String sourceName = storage.getString("source").orElse("PLAYER");
        float volume = storage.getFloat("volume").orElse(Float.valueOf(1.0f)).floatValue();
        float pitch = storage.getFloat("pitch").orElse(Float.valueOf(1.0f)).floatValue();
        try {
            source = Sound.Source.valueOf((String)sourceName.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            source = Sound.Source.PLAYER;
        }
        Sound sound = Sound.sound((Key)Key.key((String)namespace, (String)optionalSound.get()), (Sound.Source)source, (float)volume, (float)pitch);
        return new PlaySoundAction(this.server, scope, sound);
    }
}

