/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.storage.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.onestorm.library.storage.MemoryStorage;
import net.onestorm.library.storage.file.FileStorage;

public abstract class AbstractFileStorage
extends MemoryStorage
implements FileStorage {
    @Override
    public void load(File file) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        this.load(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Reader reader) throws IOException {
        BufferedReader bufferedReader;
        StringBuilder builder = new StringBuilder();
        try (BufferedReader input = reader instanceof BufferedReader ? (bufferedReader = (BufferedReader)reader) : new BufferedReader(reader);){
            String line;
            while ((line = input.readLine()) != null) {
                builder.append(line);
                builder.append('\n');
            }
        }
        this.loadFromString(builder.toString());
    }

    @Override
    public void save(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File cannot be null");
        }
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Failed to create directories for file: " + file.getAbsolutePath());
        }
        String data = this.saveToString();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            writer.write(data);
        }
    }

    protected abstract void loadFromString(String var1);

    protected abstract String saveToString();
}

