/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormregen.paper;

import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.SetFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.common.factory.Factory;
import net.onestorm.library.common.factory.GenericFactory;
import net.onestorm.library.common.factory.context.StorageBuildContext;
import net.onestorm.library.storage.StorageMap;
import net.onestorm.library.storage.file.FileStorage;
import net.onestorm.library.storage.file.json.JsonStorage;
import net.onestorm.plugins.stormregen.paper.action.Action;
import net.onestorm.plugins.stormregen.paper.action.builder.CommandActionBuilder;
import net.onestorm.plugins.stormregen.paper.action.builder.ExperienceActionBuilder;
import net.onestorm.plugins.stormregen.paper.action.builder.ItemStackActionBuilder;
import net.onestorm.plugins.stormregen.paper.command.ReloadCommand;
import net.onestorm.plugins.stormregen.paper.listener.BlockBreakListener;
import net.onestorm.plugins.stormregen.paper.regeneration.RegenerationData;
import net.onestorm.plugins.stormregen.paper.worldguard.WorldGuardListener;
import net.onestorm.plugins.stormregen.paper.worldguard.flag.BlockMaterialFlag;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.plugin.java.JavaPlugin;

public class StormRegen
extends JavaPlugin {
    public static final int DEFAULT_REGENERATION_DELAY = 10;
    public static final String DEFAULT_REPLACEMENT_BLOCK_DATA = "minecraft:air";
    public static final boolean DEFAULT_PREVENT_ITEM_DROPS = false;
    public static final boolean DEFAULT_PREVENT_EXPERIENCE_DROPS = false;
    private static final String REGENERATION_DATA_FILE_NAME = "block-list.json";
    private final FileStorage storage = new JsonStorage();
    private final Factory<Action> actionFactory = new GenericFactory<Action>();
    private StateFlag blockRegenerationFlag;
    private SetFlag<Material> allowBlockBreakFlag;
    private BlockBreakListener listener;
    private Map<Material, RegenerationData> regenerationDataMap = new ConcurrentHashMap<Material, RegenerationData>();

    public void onLoad() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            this.blockRegenerationFlag = new StateFlag("block-regeneration", false);
            registry.register((Flag)this.blockRegenerationFlag);
            this.allowBlockBreakFlag = new SetFlag("allow-block-break", (Flag)new BlockMaterialFlag(null));
            registry.register(this.allowBlockBreakFlag);
        }
        catch (FlagConflictException e) {
            this.getLogger().log(Level.WARNING, "Conflicting flag", e);
        }
    }

    public void onEnable() {
        this.listener = new BlockBreakListener(this);
        this.loadFactory();
        this.loadRegenerationDataMap();
        this.loadCommands();
        new WorldGuardListener(this);
    }

    public void onDisable() {
        this.listener.close();
    }

    private void loadRegenerationDataMap() {
        File file = new File(this.getDataFolder(), REGENERATION_DATA_FILE_NAME);
        if (!file.exists()) {
            this.saveResource(REGENERATION_DATA_FILE_NAME, false);
        }
        try {
            this.storage.load(file);
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Could not load configuration file", e);
            return;
        }
        ConcurrentHashMap<Material, RegenerationData> newRegenerationDataMap = new ConcurrentHashMap<Material, RegenerationData>();
        Optional<StorageMap> optionalRegenerationDataMap = this.storage.getMap("block-list");
        if (optionalRegenerationDataMap.isPresent()) {
            StorageMap regenerationDataMap = optionalRegenerationDataMap.get();
            regenerationDataMap.forEach((key, value) -> {
                if (!(value instanceof StorageMap)) {
                    this.getLogger().log(Level.WARNING, "The path 'block-list." + key + "' is not a Json Object");
                    return;
                }
                StorageMap storageMap = (StorageMap)value;
                try {
                    RegenerationData regenerationData = this.loadRegenerationData(storageMap);
                    newRegenerationDataMap.put(regenerationData.getTriggerMaterial(), regenerationData);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.WARNING, "Uncaught exception while creating RegenerationData (block-list." + key + ")", e);
                }
            });
        }
        this.regenerationDataMap = newRegenerationDataMap;
    }

    private RegenerationData loadRegenerationData(StorageMap storage) {
        String triggerMaterialString = storage.getString("trigger-material").orElseThrow(() -> new IllegalArgumentException("Missing key: \"trigger-material\""));
        Material triggerMaterial = Material.valueOf((String)triggerMaterialString.toUpperCase(Locale.ENGLISH));
        String replacementBlockString = storage.getString("replacement-block-data").orElse(DEFAULT_REPLACEMENT_BLOCK_DATA);
        BlockData replacementBlockData = Bukkit.createBlockData((String)replacementBlockString);
        int delay = storage.getInteger("regeneration-delay").orElse(10);
        boolean preventItemDrops = storage.getBoolean("prevent-item-drops").orElse(false);
        boolean preventExperienceDrops = storage.getBoolean("prevent-experience-drops").orElse(false);
        RegenerationData data = new RegenerationData(triggerMaterial, replacementBlockData, delay, preventItemDrops, preventExperienceDrops);
        Optional<StorageMap> optionalActionMap = storage.getMap("actions");
        if (optionalActionMap.isEmpty()) {
            return data;
        }
        StorageMap actionMap = optionalActionMap.get();
        actionMap.forEach((key, value) -> {
            Action action;
            if (!(value instanceof StorageMap)) {
                return;
            }
            StorageMap actionStorage = (StorageMap)value;
            try {
                action = this.actionFactory.build(new StorageBuildContext(actionStorage));
            }
            catch (BuildException e) {
                this.getLogger().log(Level.WARNING, "Build exception while building an action: " + key, e);
                return;
            }
            data.getActions().add(action);
        });
        return data;
    }

    private void loadCommands() {
        this.getServer().getCommandMap().register(this.getName(), (Command)new ReloadCommand(this));
    }

    private void loadFactory() {
        this.actionFactory.registerBuilder(new CommandActionBuilder(this));
        this.actionFactory.registerBuilder(new ExperienceActionBuilder(this));
        this.actionFactory.registerBuilder(new ItemStackActionBuilder());
    }

    public void reload() {
        this.loadRegenerationDataMap();
    }

    public Map<Material, RegenerationData> getRegenerationDataMap() {
        return this.regenerationDataMap;
    }

    public StateFlag getBlockRegenerationFlag() {
        return this.blockRegenerationFlag;
    }

    public SetFlag<Material> getAllowBlockBreakFlag() {
        return this.allowBlockBreakFlag;
    }
}

