/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormregen.paper.action;

import java.util.Random;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.onestorm.plugins.stormregen.paper.StormRegen;
import net.onestorm.plugins.stormregen.paper.action.Action;
import org.bukkit.block.BlockState;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerExpChangeEvent;

public class ExperienceAction
implements Action {
    private static final Random RANDOM = new Random();
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private final StormRegen plugin;
    private final double probability;
    private final boolean shouldSendMessage;
    private final String message;
    private final int minimumAmount;
    private final int maximumAmount;
    private final boolean dropExperience;

    public ExperienceAction(StormRegen plugin, double probability, boolean shouldSendMessage, String message, int minimumAmount, int maximumAmount, boolean dropExperience) {
        this.plugin = plugin;
        this.probability = probability;
        this.shouldSendMessage = shouldSendMessage;
        this.message = message;
        this.minimumAmount = minimumAmount;
        this.maximumAmount = maximumAmount;
        this.dropExperience = dropExperience;
    }

    @Override
    public void execute(BlockState state, Player player) {
        if (!(this.probability >= 1.0) && !(Math.random() < this.probability)) {
            return;
        }
        int amount = this.minimumAmount < this.maximumAmount ? RANDOM.nextInt(this.minimumAmount, this.maximumAmount) : this.maximumAmount;
        if (this.dropExperience) {
            player.getWorld().spawn(state.getLocation(), ExperienceOrb.class, experienceOrb -> experienceOrb.setExperience(amount));
        } else {
            PlayerExpChangeEvent event = new PlayerExpChangeEvent(player, amount);
            this.plugin.getServer().getPluginManager().callEvent((Event)event);
            player.giveExp(event.getAmount());
        }
        if (this.shouldSendMessage) {
            player.sendMessage(MINI_MESSAGE.deserialize(this.message));
        }
    }
}

