/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.storage;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.onestorm.library.storage.MemoryStorageList;
import net.onestorm.library.storage.Storage;
import net.onestorm.library.storage.StorageElement;
import net.onestorm.library.storage.StorageList;
import net.onestorm.library.storage.StorageMap;

public class MemoryStorageMap
implements StorageMap {
    private static final boolean OVERWRITE_SET_DEFAULT = true;
    private static final boolean OVERWRITE_SET_MAP_DEFAULT = true;
    private static final boolean OVERWRITE_SET_LIST_DEFAULT = true;
    protected Map<String, Object> map = new ConcurrentHashMap<String, Object>();
    private final Storage root;
    private final StorageElement parent;

    public MemoryStorageMap() {
        if (!(this instanceof Storage)) {
            throw new IllegalStateException("Not a root storage object");
        }
        this.root = (Storage)((Object)this);
        this.parent = null;
    }

    public MemoryStorageMap(StorageElement parent) {
        this.root = parent.getRoot();
        this.parent = parent;
    }

    @Override
    public Storage getRoot() {
        return this.root;
    }

    @Override
    public StorageElement getParent() {
        return this.parent;
    }

    @Override
    public Optional<StorageMap> getMap(String path) {
        Object value = this.get(path);
        if (value instanceof StorageMap) {
            StorageMap storageMap = (StorageMap)value;
            return Optional.of(storageMap);
        }
        return Optional.empty();
    }

    @Override
    public StorageMap setMap(String path) {
        return this.setMap(path, true);
    }

    @Override
    public StorageMap setMap(String path, boolean overwrite) {
        int trailingIndex;
        int leadingIndex = -1;
        StorageMap storageMap = this;
        char separator = this.root.getPathSeparator();
        while ((leadingIndex = path.indexOf(separator, trailingIndex = leadingIndex + 1)) != -1) {
            String node = path.substring(trailingIndex, leadingIndex);
            Optional<StorageMap> optionalStorageMap = storageMap.getMap(node);
            if (optionalStorageMap.isEmpty()) {
                storageMap = storageMap.setMap(node);
                continue;
            }
            storageMap = optionalStorageMap.get();
        }
        String key = path.substring(trailingIndex);
        if (storageMap == this) {
            Object value = this.map.get(key);
            if (!overwrite && value instanceof StorageMap) {
                StorageMap presentMap = (StorageMap)value;
                return presentMap;
            }
            MemoryStorageMap result = new MemoryStorageMap(this);
            this.map.put(key, result);
            return result;
        }
        return storageMap.setMap(key, overwrite);
    }

    @Override
    public Optional<StorageList> getList(String path) {
        Object value = this.get(path);
        if (value instanceof StorageList) {
            StorageList storageList = (StorageList)value;
            return Optional.of(storageList);
        }
        return Optional.empty();
    }

    @Override
    public StorageList setList(String path) {
        return this.setList(path, true);
    }

    @Override
    public StorageList setList(String path, boolean overwrite) {
        int trailingIndex;
        int leadingIndex = -1;
        StorageMap storageMap = this;
        char separator = this.root.getPathSeparator();
        while ((leadingIndex = path.indexOf(separator, trailingIndex = leadingIndex + 1)) != -1) {
            String node = path.substring(trailingIndex, leadingIndex);
            Optional<StorageMap> optionalStorageMap = storageMap.getMap(node);
            if (optionalStorageMap.isEmpty()) {
                storageMap = storageMap.setMap(node);
                continue;
            }
            storageMap = optionalStorageMap.get();
        }
        String key = path.substring(trailingIndex);
        if (storageMap == this) {
            Object value = this.map.get(key);
            if (!overwrite && value instanceof StorageList) {
                StorageList presentList = (StorageList)value;
                return presentList;
            }
            MemoryStorageList result = new MemoryStorageList(this);
            this.map.put(key, result);
            return result;
        }
        return storageMap.setList(key, overwrite);
    }

    @Override
    public void set(String path, Object value) {
        this.set(path, value, true);
    }

    @Override
    public void set(String path, Object value, boolean overwrite) {
        int trailingIndex;
        int leadingIndex = -1;
        StorageMap storageMap = this;
        char separator = this.root.getPathSeparator();
        while ((leadingIndex = path.indexOf(separator, trailingIndex = leadingIndex + 1)) != -1) {
            String node = path.substring(trailingIndex, leadingIndex);
            Optional<StorageMap> optionalStorageMap = storageMap.getMap(node);
            if (optionalStorageMap.isEmpty()) {
                if (value == null) {
                    return;
                }
                storageMap = storageMap.setMap(node);
                continue;
            }
            storageMap = optionalStorageMap.get();
        }
        String key = path.substring(trailingIndex);
        if (storageMap == this) {
            if (value == null) {
                this.map.remove(key);
            } else if (overwrite) {
                this.map.put(key, value);
            } else {
                this.map.putIfAbsent(key, value);
            }
        } else {
            storageMap.set(key, value, overwrite);
        }
    }

    @Override
    public Object get(String path) {
        int trailingIndex;
        int leadingIndex = -1;
        StorageMap storageMap = this;
        char separator = this.root.getPathSeparator();
        while ((leadingIndex = path.indexOf(separator, trailingIndex = leadingIndex + 1)) != -1) {
            String node = path.substring(trailingIndex, leadingIndex);
            Optional<StorageMap> optionalSection = storageMap.getMap(node);
            if (optionalSection.isEmpty()) {
                return null;
            }
            storageMap = optionalSection.get();
        }
        String key = path.substring(trailingIndex);
        if (storageMap == this) {
            return this.map.get(key);
        }
        return storageMap.get(key);
    }

    @Override
    public Optional<UUID> getUuid(String path) {
        Object value = this.get(path);
        if (value instanceof UUID) {
            UUID uuid = (UUID)value;
            return Optional.of(uuid);
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(UUID.fromString(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> getBoolean(String path) {
        Object value = this.get(path);
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return Optional.of(bool);
        }
        if (value instanceof String) {
            String string = (String)value;
            if ("true".equalsIgnoreCase(string)) {
                return Optional.of(true);
            }
            if ("false".equalsIgnoreCase(string)) {
                return Optional.of(false);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getString(String path) {
        Object value = this.get(path);
        if (value instanceof String) {
            String string = (String)value;
            return Optional.of(string);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.toString());
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return Optional.of(bool.toString());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Double> getDouble(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.doubleValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<BigDecimal> getBigDecimal(String path) {
        Object value = this.get(path);
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return Optional.of(bigDecimal);
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(new BigDecimal(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<BigInteger> getBigInteger(String path) {
        Object value = this.get(path);
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return Optional.of(bigInteger);
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(new BigInteger(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Float> getFloat(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(Float.valueOf(number.floatValue()));
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Float.valueOf(Float.parseFloat(string)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> getLong(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.longValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Short> getShort(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.shortValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Short.parseShort(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Integer> getInteger(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.intValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Byte> getByte(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.byteValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Byte.parseByte(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Character> getCharacter(String path) {
        Optional<String> optionalValue = this.getString(path);
        if (optionalValue.isEmpty()) {
            return Optional.empty();
        }
        String value = optionalValue.get();
        if (value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(value.charAt(0)));
    }

    @Override
    public void forEach(BiConsumer<String, Object> action) {
        this.map.forEach(action);
    }
}

