/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormregen.paper.action.builder;

import java.util.Optional;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.common.factory.Builder;
import net.onestorm.library.common.factory.context.BuildContext;
import net.onestorm.library.common.factory.context.StorageBuildContext;
import net.onestorm.library.storage.StorageMap;
import net.onestorm.plugins.stormregen.paper.action.Action;

public abstract class AbstractActionBuilder
implements Builder<Action> {
    private static final double DEFAULT_PROBABILITY = 0.0;
    private static final String DEFAULT_MESSAGE = "<red>Error: No message set</red>";
    private static final int DEFAULT_AMOUNT = 0;

    @Override
    public Action build(BuildContext context) {
        if (!(context instanceof StorageBuildContext)) {
            throw new BuildException("Context is not an instance of StorageBuildContext.");
        }
        StorageBuildContext storageContext = (StorageBuildContext)context;
        StorageMap storage = storageContext.getStorage();
        double probability = storage.getDouble("probability").orElse(0.0);
        Optional<String> optionalMessage = storage.getString("message");
        boolean shouldSendMessage = optionalMessage.isPresent();
        String message = optionalMessage.orElse(DEFAULT_MESSAGE);
        int minimumAmount = storage.getInteger("minimum-amount").orElse(storage.getInteger("amount").orElse(0));
        int maximumAmount = storage.getInteger("maximum-amount").orElse(storage.getInteger("amount").orElse(0));
        return this.build(storage, probability, shouldSendMessage, message, minimumAmount, maximumAmount);
    }

    protected abstract Action build(StorageMap var1, double var2, boolean var4, String var5, int var6, int var7);
}

