/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormregen.paper.listener;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.ProtectionQuery;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.onestorm.plugins.stormregen.paper.StormRegen;
import net.onestorm.plugins.stormregen.paper.regeneration.RegenerationData;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class BlockBreakHandler
implements EventExecutor,
Listener {
    private static final long TICKS_IN_SECOND = 20L;
    private static final ProtectionQuery PROTECTION_QUERY = new ProtectionQuery();
    private final Map<Block, Regeneration> regenerationMap = new ConcurrentHashMap<Block, Regeneration>();
    private final StormRegen plugin;

    public BlockBreakHandler(StormRegen plugin) {
        this.plugin = plugin;
    }

    public void handle(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        com.sk89q.worldedit.util.Location location = BukkitAdapter.adapt((Location)block.getLocation());
        if (!query.testState(location, localPlayer, new StateFlag[]{this.plugin.getBlockRegenerationFlag()})) {
            return;
        }
        if (!PROTECTION_QUERY.testBlockBreak((Object)player, block)) {
            return;
        }
        RegenerationData regenerationData = this.plugin.getRegenerationDataMap().get(block.getType());
        if (regenerationData == null) {
            return;
        }
        if (regenerationData.preventExperienceDrops()) {
            event.setExpToDrop(0);
        }
        if (regenerationData.preventItemDrops()) {
            event.setDropItems(false);
        }
        BukkitScheduler scheduler = this.plugin.getServer().getScheduler();
        BlockState blockState = block.getState();
        RegenerationData finalRegenerationData = regenerationData;
        scheduler.runTask((Plugin)this.plugin, () -> {
            BlockData replacementBlock = finalRegenerationData.getReplacementBlock();
            if (!replacementBlock.getMaterial().isAir()) {
                block.setBlockData(finalRegenerationData.getReplacementBlock());
            }
            finalRegenerationData.getActions().forEach(blockAction -> blockAction.execute(blockState, player));
        });
        if (this.regenerationMap.containsKey(block)) {
            return;
        }
        BukkitTask task = scheduler.runTaskLater((Plugin)this.plugin, () -> {
            Regeneration regeneration = this.regenerationMap.remove(block);
            if (regeneration == null) {
                return;
            }
            block.setBlockData(regeneration.originalBlockState().getBlockData());
        }, (long)regenerationData.getDelay() * 20L);
        this.regenerationMap.put(block, new Regeneration(task, block.getState()));
    }

    public void close() {
        HandlerList.unregisterAll((Listener)this);
        this.regenerationMap.forEach((block, regeneration) -> {
            regeneration.task().cancel();
            block.setBlockData(regeneration.originalBlockState().getBlockData());
        });
    }

    public void register(EventPriority priority) {
        this.plugin.getServer().getPluginManager().registerEvent(BlockBreakEvent.class, (Listener)this, priority, (EventExecutor)this, (Plugin)this.plugin, true);
    }

    public void execute(@NotNull Listener listener, @NotNull Event event) {
        if (!(event instanceof BlockBreakEvent)) {
            return;
        }
        BlockBreakEvent blockBreakEvent = (BlockBreakEvent)event;
        this.handle(blockBreakEvent);
    }

    private record Regeneration(BukkitTask task, BlockState originalBlockState) {
    }
}

