/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.storage.file.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.concurrent.ConcurrentHashMap;
import net.onestorm.library.storage.MemoryStorageList;
import net.onestorm.library.storage.MemoryStorageMap;
import net.onestorm.library.storage.StorageElement;
import net.onestorm.library.storage.StorageList;
import net.onestorm.library.storage.StorageMap;
import net.onestorm.library.storage.file.AbstractFileStorage;
import net.onestorm.library.storage.file.json.StorageListSerializer;
import net.onestorm.library.storage.file.json.StorageMapSerializer;

public class JsonStorage
extends AbstractFileStorage {
    private final Gson gson;

    public JsonStorage() {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.setPrettyPrinting();
        builder.registerTypeHierarchyAdapter(StorageMap.class, new StorageMapSerializer());
        builder.registerTypeHierarchyAdapter(StorageList.class, new StorageListSerializer());
        this.gson = builder.create();
    }

    @Override
    protected void loadFromString(String data) {
        ConcurrentHashMap result = new ConcurrentHashMap();
        JsonObject jsonObject = this.gson.fromJson(data, JsonObject.class);
        if (jsonObject == null) {
            throw new NullPointerException("Json (String) is null or empty");
        }
        jsonObject.asMap().forEach((? super K key, ? super V value) -> {
            if (value instanceof JsonObject) {
                JsonObject nextObject = (JsonObject)value;
                result.put(key, this.createStorageMap(nextObject, this));
            } else if (value instanceof JsonArray) {
                JsonArray nextArray = (JsonArray)value;
                result.put(key, this.createStorageList(nextArray, this));
            } else if (value instanceof JsonPrimitive) {
                JsonPrimitive nextPrimitive = (JsonPrimitive)value;
                Object primitive = this.createPrimitive(nextPrimitive);
                if (primitive == null) {
                    return;
                }
                result.put(key, primitive);
            }
        });
        this.map = result;
    }

    private StorageMap createStorageMap(JsonObject jsonObject, StorageElement parent) {
        MemoryStorageMap result = new MemoryStorageMap(parent);
        jsonObject.asMap().forEach((? super K key, ? super V jsonElement) -> {
            if (jsonElement instanceof JsonObject) {
                JsonObject nextObject = (JsonObject)jsonElement;
                result.set((String)key, this.createStorageMap(nextObject, result));
            } else if (jsonElement instanceof JsonArray) {
                JsonArray nextArray = (JsonArray)jsonElement;
                result.set((String)key, this.createStorageList(nextArray, result));
            } else if (jsonElement instanceof JsonPrimitive) {
                JsonPrimitive nextPrimitive = (JsonPrimitive)jsonElement;
                Object value = this.createPrimitive(nextPrimitive);
                if (value == null) {
                    return;
                }
                result.set((String)key, value, true);
            }
        });
        return result;
    }

    private StorageList createStorageList(JsonArray jsonArray, StorageElement parent) {
        MemoryStorageList result = new MemoryStorageList(parent);
        jsonArray.forEach((? super T value) -> {
            if (value instanceof JsonObject) {
                JsonObject nextObject = (JsonObject)value;
                result.add(this.createStorageMap(nextObject, result));
            } else if (value instanceof JsonArray) {
                JsonArray nextArray = (JsonArray)value;
                result.add(this.createStorageList(nextArray, result));
            } else if (value instanceof JsonPrimitive) {
                JsonPrimitive nextPrimitive = (JsonPrimitive)value;
                Object primitive = this.createPrimitive(nextPrimitive);
                if (primitive == null) {
                    return;
                }
                result.add(primitive);
            }
        });
        return result;
    }

    private Object createPrimitive(JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isString()) {
            return jsonPrimitive.getAsString();
        }
        if (jsonPrimitive.isNumber()) {
            return jsonPrimitive.getAsNumber();
        }
        if (jsonPrimitive.isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        return null;
    }

    @Override
    protected String saveToString() {
        return this.gson.toJson(this);
    }
}

