/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormregen.paper;

import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.SetFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.common.factory.Factory;
import net.onestorm.library.common.factory.GenericFactory;
import net.onestorm.library.common.factory.context.StorageBuildContext;
import net.onestorm.library.storage.StorageMap;
import net.onestorm.library.storage.file.FileStorage;
import net.onestorm.library.storage.file.json.JsonStorage;
import net.onestorm.plugins.stormregen.paper.action.Action;
import net.onestorm.plugins.stormregen.paper.action.builder.CommandActionBuilder;
import net.onestorm.plugins.stormregen.paper.action.builder.ExperienceActionBuilder;
import net.onestorm.plugins.stormregen.paper.action.builder.GiveItemActionBuilder;
import net.onestorm.plugins.stormregen.paper.action.builder.ItemStackActionBuilder;
import net.onestorm.plugins.stormregen.paper.command.ReloadCommand;
import net.onestorm.plugins.stormregen.paper.listener.BlockBreakHandler;
import net.onestorm.plugins.stormregen.paper.regeneration.RegenerationData;
import net.onestorm.plugins.stormregen.paper.worldguard.WorldGuardHandler;
import net.onestorm.plugins.stormregen.paper.worldguard.flag.BlockMaterialFlag;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public class StormRegen
extends JavaPlugin {
    public static final int DEFAULT_REGENERATION_DELAY = 10;
    public static final String DEFAULT_REPLACEMENT_BLOCK_DATA = "minecraft:air";
    public static final boolean DEFAULT_PREVENT_ITEM_DROPS = false;
    public static final boolean DEFAULT_PREVENT_EXPERIENCE_DROPS = false;
    private static final String REGENERATION_DATA_FILE_NAME = "block-list.json";
    public static final String WORLD_GUARD_PRIORITY_PATH = "event-priority.world-guard-break-block";
    public static final String BUKKIT_PRIORITY_PATH = "event-priority.bukkit-block-break";
    public static final String DEFAULT_EVENT_PRIORITY_STRING = "LOWEST";
    public static final EventPriority DEFAULT_EVENT_PRIORITY = EventPriority.LOWEST;
    private static final String CONFIGURATION_FILE_NAME = "configuration.json";
    private final FileStorage regenerationDataStorage = new JsonStorage();
    private final FileStorage configurationStorage = new JsonStorage();
    private final Factory<Action> actionFactory = new GenericFactory<Action>();
    private EventPriority blockBreakEventPriority;
    private EventPriority worldGuardEventPriority;
    private StateFlag blockRegenerationFlag;
    private SetFlag<Material> allowBlockBreakFlag;
    private BlockBreakHandler blockBreakHandler;
    private WorldGuardHandler worldGuardHandler;
    private Map<Material, RegenerationData> regenerationDataMap = new ConcurrentHashMap<Material, RegenerationData>();

    public void onLoad() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            this.blockRegenerationFlag = new StateFlag("block-regeneration", false);
            registry.register((Flag)this.blockRegenerationFlag);
            this.allowBlockBreakFlag = new SetFlag("allow-block-break", (Flag)new BlockMaterialFlag(null));
            registry.register(this.allowBlockBreakFlag);
        }
        catch (FlagConflictException e) {
            this.getLogger().log(Level.WARNING, "Conflicting flag", e);
        }
    }

    public void onEnable() {
        this.loadFactory();
        this.loadConfiguration();
        this.loadRegenerationDataMap();
        this.loadEvents();
        this.loadCommands();
    }

    public void onDisable() {
        this.blockBreakHandler.close();
    }

    private void loadFactory() {
        this.actionFactory.registerBuilder(new CommandActionBuilder(this));
        this.actionFactory.registerBuilder(new ExperienceActionBuilder(this));
        this.actionFactory.registerBuilder(new ItemStackActionBuilder());
        this.actionFactory.registerBuilder(new GiveItemActionBuilder());
    }

    private void loadConfiguration() {
        File file = new File(this.getDataFolder(), CONFIGURATION_FILE_NAME);
        if (!file.exists()) {
            this.saveResource(CONFIGURATION_FILE_NAME, false);
        }
        try {
            this.configurationStorage.load(file);
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Could not load configuration.json file", e);
            return;
        }
        String worldGuardPriorityString = this.configurationStorage.getString(WORLD_GUARD_PRIORITY_PATH).orElse(DEFAULT_EVENT_PRIORITY_STRING);
        String bukkitPriorityString = this.configurationStorage.getString(BUKKIT_PRIORITY_PATH).orElse(DEFAULT_EVENT_PRIORITY_STRING);
        try {
            this.worldGuardEventPriority = EventPriority.valueOf((String)worldGuardPriorityString);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().log(Level.WARNING, "Invalid priority given for \"event-priority.world-guard-break-block\". defaulting to " + DEFAULT_EVENT_PRIORITY.name(), e);
            this.worldGuardEventPriority = DEFAULT_EVENT_PRIORITY;
        }
        try {
            this.blockBreakEventPriority = EventPriority.valueOf((String)bukkitPriorityString);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().log(Level.WARNING, "Invalid priority given for \"event-priority.bukkit-block-break\". defaulting to " + DEFAULT_EVENT_PRIORITY.name(), e);
            this.blockBreakEventPriority = DEFAULT_EVENT_PRIORITY;
        }
    }

    private void loadRegenerationDataMap() {
        File file = new File(this.getDataFolder(), REGENERATION_DATA_FILE_NAME);
        if (!file.exists()) {
            this.saveResource(REGENERATION_DATA_FILE_NAME, false);
        }
        try {
            this.regenerationDataStorage.load(file);
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Could not load block-list.json file", e);
            return;
        }
        ConcurrentHashMap<Material, RegenerationData> newRegenerationDataMap = new ConcurrentHashMap<Material, RegenerationData>();
        Optional<StorageMap> optionalRegenerationDataMap = this.regenerationDataStorage.getMap("block-list");
        if (optionalRegenerationDataMap.isPresent()) {
            StorageMap regenerationDataMap = optionalRegenerationDataMap.get();
            regenerationDataMap.forEach((key, value) -> {
                if (!(value instanceof StorageMap)) {
                    this.getLogger().log(Level.WARNING, "The path 'block-list." + key + "' is not a Json Object");
                    return;
                }
                StorageMap storageMap = (StorageMap)value;
                try {
                    RegenerationData regenerationData = this.loadRegenerationData(storageMap);
                    newRegenerationDataMap.put(regenerationData.getTriggerMaterial(), regenerationData);
                }
                catch (Exception e) {
                    this.getLogger().log(Level.WARNING, "Uncaught exception while creating RegenerationData (block-list." + key + ")", e);
                }
            });
        }
        this.regenerationDataMap = newRegenerationDataMap;
    }

    private RegenerationData loadRegenerationData(StorageMap storage) {
        String triggerMaterialString = storage.getString("trigger-material").orElseThrow(() -> new IllegalArgumentException("Missing key: \"trigger-material\""));
        Material triggerMaterial = Material.valueOf((String)triggerMaterialString.toUpperCase(Locale.ENGLISH));
        String replacementBlockString = storage.getString("replacement-block-data").orElse(DEFAULT_REPLACEMENT_BLOCK_DATA);
        BlockData replacementBlockData = Bukkit.createBlockData((String)replacementBlockString);
        int delay = storage.getInteger("regeneration-delay").orElse(10);
        boolean preventItemDrops = storage.getBoolean("prevent-item-drops").orElse(false);
        boolean preventExperienceDrops = storage.getBoolean("prevent-experience-drops").orElse(false);
        RegenerationData data = new RegenerationData(triggerMaterial, replacementBlockData, delay, preventItemDrops, preventExperienceDrops);
        Optional<StorageMap> optionalActionMap = storage.getMap("actions");
        if (optionalActionMap.isEmpty()) {
            return data;
        }
        StorageMap actionMap = optionalActionMap.get();
        actionMap.forEach((key, value) -> {
            Action action;
            if (!(value instanceof StorageMap)) {
                return;
            }
            StorageMap actionStorage = (StorageMap)value;
            try {
                action = this.actionFactory.build(new StorageBuildContext(actionStorage));
            }
            catch (BuildException e) {
                this.getLogger().log(Level.WARNING, "Build exception while building an action: " + key, e);
                return;
            }
            data.getActions().add(action);
        });
        return data;
    }

    private void loadEvents() {
        if (this.blockBreakHandler != null) {
            this.blockBreakHandler.close();
        }
        if (this.worldGuardHandler != null) {
            HandlerList.unregisterAll((Listener)this.worldGuardHandler);
        }
        this.blockBreakHandler = new BlockBreakHandler(this);
        this.worldGuardHandler = new WorldGuardHandler(this);
        this.blockBreakHandler.register(this.blockBreakEventPriority);
        this.worldGuardHandler.register(this.worldGuardEventPriority);
    }

    private void loadCommands() {
        LifecycleEventManager manager = this.getLifecycleManager();
        manager.registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> {
            Commands commands = (Commands)event.registrar();
            commands.register("stormregenreload", List.of("srreload"), (BasicCommand)new ReloadCommand(this));
        });
    }

    public void reload() {
        this.loadRegenerationDataMap();
        this.loadConfiguration();
        this.loadEvents();
    }

    public Map<Material, RegenerationData> getRegenerationDataMap() {
        return this.regenerationDataMap;
    }

    public StateFlag getBlockRegenerationFlag() {
        return this.blockRegenerationFlag;
    }

    public SetFlag<Material> getAllowBlockBreakFlag() {
        return this.allowBlockBreakFlag;
    }
}

