/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.internal.async.function.RetryState;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;

@NotThreadSafe
public final class RetryingSyncSupplier<R>
implements Supplier<R> {
    private final RetryState state;
    private final BiPredicate<RetryState, Throwable> retryPredicate;
    private final BinaryOperator<Throwable> failedResultTransformer;
    private final Supplier<R> syncFunction;

    public RetryingSyncSupplier(RetryState state, BinaryOperator<Throwable> failedResultTransformer, BiPredicate<RetryState, Throwable> retryPredicate, Supplier<R> syncFunction) {
        this.state = state;
        this.retryPredicate = retryPredicate;
        this.failedResultTransformer = failedResultTransformer;
        this.syncFunction = syncFunction;
    }

    @Override
    public R get() {
        while (true) {
            try {
                return this.syncFunction.get();
            }
            catch (RuntimeException attemptException) {
                this.state.advanceOrThrow(attemptException, this.failedResultTransformer, this.retryPredicate);
                continue;
            }
            catch (Exception attemptException) {
                this.state.advanceOrThrow(new RuntimeException(attemptException), this.failedResultTransformer, this.retryPredicate);
                continue;
            }
            break;
        }
    }
}

