/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.configuration.file;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.onestorm.library.configuration.Configuration;
import net.onestorm.library.configuration.Section;

public class MemorySection
implements Section {
    private static final char SEPARATOR = '.';
    private static final boolean SET_OVERWRITE_DEFAULT = true;
    protected Map<String, Object> map = new ConcurrentHashMap<String, Object>();
    private final Configuration root;
    private final Section parent;

    public MemorySection() {
        if (!(this instanceof Configuration)) {
            throw new IllegalStateException("Not a root Section");
        }
        this.root = (Configuration)((Object)this);
        this.parent = null;
    }

    public MemorySection(Section parent) {
        this.root = parent.getRoot();
        this.parent = parent;
    }

    @Override
    public Configuration getRoot() {
        return this.root;
    }

    @Override
    public Section getParent() {
        return this.parent;
    }

    @Override
    public Optional<Section> getSection(String path) {
        Object value = this.get(path);
        if (value instanceof Section) {
            Section section = (Section)value;
            return Optional.of(section);
        }
        return Optional.empty();
    }

    @Override
    public Section createSection(String path) {
        int trailingIndex;
        int leadingIndex = -1;
        Section section = this;
        while ((leadingIndex = path.indexOf(46, trailingIndex = leadingIndex + 1)) != -1) {
            String node = path.substring(trailingIndex, leadingIndex);
            Optional<Section> optionalSection = section.getSection(node);
            if (optionalSection.isEmpty()) {
                section = section.createSection(node);
                continue;
            }
            section = optionalSection.get();
        }
        String key = path.substring(trailingIndex);
        if (section == this) {
            MemorySection result = new MemorySection(this);
            this.map.put(key, result);
            return result;
        }
        return section.createSection(key);
    }

    @Override
    public void set(String path, Object value) {
        this.set(path, value, true);
    }

    @Override
    public void set(String path, Object value, boolean overwrite) {
        int trailingIndex;
        int leadingIndex = -1;
        Section section = this;
        while ((leadingIndex = path.indexOf(46, trailingIndex = leadingIndex + 1)) != -1) {
            String node = path.substring(trailingIndex, leadingIndex);
            Optional<Section> optionalSection = section.getSection(node);
            if (optionalSection.isEmpty()) {
                if (value == null) {
                    return;
                }
                section = section.createSection(node);
                continue;
            }
            section = optionalSection.get();
        }
        String key = path.substring(trailingIndex);
        if (section == this) {
            if (value == null) {
                this.map.remove(key);
            } else if (overwrite) {
                this.map.put(key, value);
            } else {
                this.map.putIfAbsent(key, value);
            }
        } else {
            section.set(key, value, overwrite);
        }
    }

    @Override
    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    @Override
    public List<Object> asList() {
        return List.copyOf(this.map.values());
    }

    @Override
    public Optional<List<Object>> getList(String path) {
        Object value = this.get(path);
        if (value instanceof Section) {
            Section section = (Section)value;
            return Optional.of(section.asList());
        }
        if (value instanceof List) {
            return Optional.of((List)value);
        }
        return Optional.empty();
    }

    @Override
    public Object get(String path) {
        int trailingIndex;
        int leadingIndex = -1;
        Section section = this;
        while ((leadingIndex = path.indexOf(46, trailingIndex = leadingIndex + 1)) != -1) {
            String node = path.substring(trailingIndex, leadingIndex);
            Optional<Section> optionalSection = section.getSection(node);
            if (optionalSection.isEmpty()) {
                return null;
            }
            section = optionalSection.get();
        }
        String key = path.substring(trailingIndex);
        if (section == this) {
            return this.map.get(key);
        }
        return section.get(key);
    }

    @Override
    public Optional<Boolean> getBoolean(String path) {
        Object value = this.get(path);
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return Optional.of(bool);
        }
        if (value instanceof String) {
            String string = (String)value;
            if ("true".equalsIgnoreCase(string)) {
                return Optional.of(true);
            }
            if ("false".equalsIgnoreCase(string)) {
                return Optional.of(false);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getString(String path) {
        Object value = this.get(path);
        if (value instanceof String) {
            String string = (String)value;
            return Optional.of(string);
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.toString());
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return Optional.of(bool.toString());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Double> getDouble(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.doubleValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Double.parseDouble(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<BigDecimal> getBigDecimal(String path) {
        Object value = this.get(path);
        if (value instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)value;
            return Optional.of(bigDecimal);
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(new BigDecimal(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<BigInteger> getBigInteger(String path) {
        Object value = this.get(path);
        if (value instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)value;
            return Optional.of(bigInteger);
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(new BigInteger(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Float> getFloat(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(Float.valueOf(number.floatValue()));
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Float.valueOf(Float.parseFloat(string)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Long> getLong(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.longValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Long.parseLong(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Short> getShort(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.shortValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Short.parseShort(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Integer> getInteger(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.intValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Byte> getByte(String path) {
        Object value = this.get(path);
        if (value instanceof Number) {
            Number number = (Number)value;
            return Optional.of(number.byteValue());
        }
        if (value instanceof String) {
            String string = (String)value;
            try {
                return Optional.of(Byte.parseByte(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Character> getCharacter(String path) {
        Optional<String> optionalValue = this.getString(path);
        if (optionalValue.isEmpty()) {
            return Optional.empty();
        }
        String value = optionalValue.get();
        if (value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(value.charAt(0)));
    }
}

