/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.action;

import java.util.Locale;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.onestorm.library.action.Action;
import net.onestorm.library.action.ActionBuilder;
import net.onestorm.library.configuration.Section;
import net.onestorm.library.paper.action.PlaySoundAction;
import org.bukkit.Server;

public class PlaySoundActionBuilder
implements ActionBuilder {
    private static final String ACTION_BUILDER_NAME = "play-sound";
    private final Server server;

    public PlaySoundActionBuilder(Server server) {
        this.server = server;
    }

    @Override
    public String getName() {
        return ACTION_BUILDER_NAME;
    }

    @Override
    public Action build(Section configuration) {
        Sound.Source source;
        Optional<String> optionalSound = configuration.getString("sound");
        if (optionalSound.isEmpty()) {
            throw new IllegalArgumentException("Missing \"sound\" key in configuration");
        }
        String scope = configuration.getString("scope").orElse("player");
        String namespace = configuration.getString("namespace").orElse("minecraft");
        String sourceName = configuration.getString("source").orElse("PLAYER");
        float volume = configuration.getFloat("volume").orElse(Float.valueOf(1.0f)).floatValue();
        float pitch = configuration.getFloat("pitch").orElse(Float.valueOf(1.0f)).floatValue();
        try {
            source = Sound.Source.valueOf(sourceName.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            source = Sound.Source.PLAYER;
        }
        Sound sound = Sound.sound(Key.key(namespace, optionalSound.get()), source, volume, pitch);
        return new PlaySoundAction(this.server, scope, sound);
    }
}

