/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormutils.core.storage;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import java.util.Optional;
import java.util.UUID;
import net.onestorm.library.storage.Storage;
import net.onestorm.plugins.stormutils.api.UtilPlugin;
import net.onestorm.plugins.stormutils.api.storage.StorageManager;
import net.onestorm.plugins.stormutils.api.storage.UserStorage;
import net.onestorm.plugins.stormutils.core.storage.UserStorageImpl;
import org.bson.Document;
import org.bson.UuidRepresentation;

public class MongoStorageManager
implements StorageManager {
    private static final ReplaceOptions REPLACE_OPTIONS = new ReplaceOptions().upsert(true);
    private final UtilPlugin plugin;
    private MongoClient client;
    private MongoDatabase database;

    public MongoStorageManager(UtilPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void initialize() {
        Storage configuration = this.plugin.getConfiguration();
        String host = configuration.getString("database.host").orElse("localhost");
        String port = configuration.getString("database.port").orElse("27017");
        String name = configuration.getString("database.name").orElse("storm");
        MongoClientSettings.Builder settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString("mongodb://" + host + ":" + port)).uuidRepresentation(UuidRepresentation.JAVA_LEGACY);
        Optional<String> optionalUsername = this.plugin.getConfiguration().getString("database.username");
        Optional<String> optionalPassword = this.plugin.getConfiguration().getString("database.password");
        if (optionalUsername.isPresent() && optionalPassword.isPresent()) {
            String username = optionalUsername.get();
            String password = optionalPassword.get();
            settings.credential(MongoCredential.createCredential(username, name, password.toCharArray()));
        }
        this.client = MongoClients.create(settings.build());
        this.database = this.client.getDatabase(name);
    }

    @Override
    public Optional<UserStorage> getUserStorage(UUID uuid) {
        MongoCollection<Document> userCollection = this.database.getCollection("users");
        Document document = (Document)userCollection.find(Filters.eq("_id", uuid)).first();
        if (document == null) {
            return Optional.empty();
        }
        UserStorageImpl userStorage = new UserStorageImpl();
        userStorage.fromMap(document);
        return Optional.of(userStorage);
    }

    @Override
    public Optional<UserStorage> getUserStorage(String username) {
        MongoCollection<Document> userCollection = this.database.getCollection("users");
        Document document = (Document)userCollection.find(Filters.eq("last-known-username", username)).first();
        if (document == null) {
            return Optional.empty();
        }
        UserStorageImpl userStorage = new UserStorageImpl();
        userStorage.fromMap(document);
        return Optional.of(userStorage);
    }

    @Override
    public void setUserStorage(UUID uuid, UserStorage userStorage) {
        Document document = new Document(userStorage.toMap());
        document.put("_id", (Object)uuid);
        MongoCollection<Document> userCollection = this.database.getCollection("users");
        userCollection.replaceOne(Filters.eq("_id", uuid), document, REPLACE_OPTIONS);
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

