/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormutils.core.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.onestorm.library.storage.MemoryStorage;
import net.onestorm.library.storage.MemoryStorageList;
import net.onestorm.library.storage.MemoryStorageMap;
import net.onestorm.library.storage.StorageElement;
import net.onestorm.library.storage.StorageList;
import net.onestorm.library.storage.StorageMap;
import net.onestorm.plugins.stormutils.api.storage.UserStorage;

public class UserStorageImpl
extends MemoryStorage
implements UserStorage {
    @Override
    public void fromMap(Map<String, Object> map) {
        ConcurrentHashMap result = new ConcurrentHashMap();
        map.forEach((? super K key, ? super V value) -> {
            if (value instanceof Map) {
                Map nextMap = (Map)value;
                result.put(key, this.createStorageMap(nextMap, this));
            } else if (value instanceof List) {
                List nextList = (List)value;
                result.put(key, this.createStorageList(nextList, this));
            } else if (value != null) {
                result.put(key, value);
            }
        });
        this.map = result;
    }

    private StorageMap createStorageMap(Map<String, Object> map, StorageElement parent) {
        MemoryStorageMap result = new MemoryStorageMap(parent);
        map.forEach((? super K key, ? super V value) -> {
            if (value instanceof Map) {
                Map nextMap = (Map)value;
                result.set((String)key, this.createStorageMap(nextMap, this));
            } else if (value instanceof List) {
                List nextList = (List)value;
                result.set((String)key, this.createStorageList(nextList, this));
            } else if (value != null) {
                result.set((String)key, value);
            }
        });
        return result;
    }

    private StorageList createStorageList(List<Object> list, StorageElement parent) {
        MemoryStorageList result = new MemoryStorageList(parent);
        list.forEach((? super T value) -> {
            if (value instanceof Map) {
                Map nextMap = (Map)value;
                result.add(this.createStorageMap(nextMap, result));
            } else if (value instanceof List) {
                List nextList = (List)value;
                result.add(this.createStorageList(nextList, result));
            } else if (value != null) {
                result.add(value);
            }
        });
        return result;
    }

    @Override
    public Map<String, Object> toMap() {
        return this.createMap(this);
    }

    private Map<String, Object> createMap(StorageMap map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        map.forEach((key, value) -> {
            if (value instanceof StorageMap) {
                StorageMap nextMap = (StorageMap)value;
                result.put((String)key, this.createMap(nextMap));
            } else if (value instanceof StorageList) {
                StorageList nextList = (StorageList)value;
                result.put((String)key, this.createList(nextList));
            } else if (value != null) {
                result.put((String)key, value);
            }
        });
        return result;
    }

    private List<Object> createList(StorageList list) {
        ArrayList<Object> result = new ArrayList<Object>();
        list.forEach((? super T value) -> {
            if (value instanceof StorageMap) {
                StorageMap nextMap = (StorageMap)value;
                result.add(this.createMap(nextMap));
            } else if (value instanceof StorageList) {
                StorageList nextList = (StorageList)value;
                result.add(this.createList(nextList));
            } else if (value != null) {
                result.add(value);
            }
        });
        return result;
    }
}

