/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.onestorm.library.action.Action;
import net.onestorm.library.action.ActionBuilder;
import net.onestorm.library.action.ActionManager;
import net.onestorm.library.configuration.Section;

public class ActionManagerImpl
implements ActionManager {
    private final Map<String, ActionBuilder> builderMap = new HashMap<String, ActionBuilder>();
    private final Logger logger;

    public ActionManagerImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void registerBuilder(ActionBuilder builder) {
        String name = builder.getName().toLowerCase(Locale.ENGLISH);
        if (this.builderMap.containsKey(name)) {
            throw new IllegalArgumentException("There already exists a builder with this name: " + name);
        }
        this.builderMap.put(name, builder);
    }

    @Override
    public void unregisterBuilder(ActionBuilder builder) {
        String name = builder.getName().toLowerCase(Locale.ENGLISH);
        this.builderMap.remove(name);
    }

    @Override
    public List<Action> getActions(Section configuration) {
        ArrayList<Action> result = new ArrayList<Action>();
        configuration.asMap().keySet().forEach(key -> {
            Action action;
            Optional<Section> optionalSection = configuration.getSection((String)key);
            if (optionalSection.isEmpty()) {
                return;
            }
            Section section = optionalSection.get();
            Optional<String> optionalName = section.getString("type");
            if (optionalName.isEmpty()) {
                this.logger.warning("Missing \"type\" key in configuration for Action: " + key);
                return;
            }
            String name = optionalName.get();
            ActionBuilder builder = this.builderMap.get(name);
            if (builder == null) {
                this.logger.warning("Could not find a builder for Action: " + name);
                return;
            }
            try {
                action = builder.build(section);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Uncaught error while building an Action: " + name, e);
                return;
            }
            result.add(action);
        });
        return result;
    }
}

