/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.configuration.file.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import net.onestorm.library.configuration.Section;
import net.onestorm.library.configuration.file.MemorySection;

public class SectionDeserializer
implements JsonDeserializer<ConcurrentHashMap<String, Object>> {
    private final Section root;

    public SectionDeserializer(Section root) {
        this.root = root;
    }

    @Override
    public ConcurrentHashMap<String, Object> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        JsonObject jsonObject = json.getAsJsonObject();
        jsonObject.asMap().forEach((key, element) -> {
            if (element instanceof JsonObject) {
                JsonObject object = (JsonObject)element;
                MemorySection section = new MemorySection(this.root);
                this.createChildren((Section)section, object, context);
                map.put((String)key, section);
            } else if (element instanceof JsonArray) {
                JsonArray array = (JsonArray)element;
                MemorySection section = new MemorySection(this.root);
                this.createChildren((Section)section, array, context);
                map.put((String)key, section);
            } else {
                Object value = context.deserialize((JsonElement)element, (Type)((Object)Object.class));
                map.put((String)key, value);
            }
        });
        return map;
    }

    public void createChildren(Section parent, JsonObject object, JsonDeserializationContext context) {
        object.asMap().forEach((key, element) -> this.createChild(parent, (String)key, (JsonElement)element, context));
    }

    public void createChildren(Section parent, JsonArray array, JsonDeserializationContext context) {
        for (int index = 0; index < array.size(); ++index) {
            String key = String.valueOf(index);
            JsonElement element = array.get(index);
            this.createChild(parent, key, element, context);
        }
    }

    public void createChild(Section parent, String key, JsonElement element, JsonDeserializationContext context) {
        if (element instanceof JsonObject) {
            JsonObject object = (JsonObject)element;
            Section section = parent.createSection(key);
            this.createChildren(section, object, context);
        } else if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            Section section = parent.createSection(key);
            this.createChildren(section, array, context);
        } else {
            Object value = context.deserialize(element, (Type)((Object)Object.class));
            parent.set(key, value);
        }
    }
}

