/*
 * Decompiled with CFR 0.152.
 */
package eu.internetpolice.spa.config;

import eu.internetpolice.spa.SuperpickaxeReloaded;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;

public class Config {
    private final Set<Material> blacklistedBlocks = new HashSet<Material>();
    private final Set<Material> spaTools = new HashSet<Material>();
    private final boolean monitorWorldChanges;
    private final boolean overrideWorldEdit;

    public Config(SuperpickaxeReloaded plugin) {
        plugin.saveDefaultConfig();
        plugin.reloadConfig();
        for (String materialName : plugin.getConfig().getStringList("blacklisted")) {
            if (Material.matchMaterial((String)materialName) == null) {
                plugin.getLogger().warning("Ignoring invalid material in blacklist: " + materialName);
                continue;
            }
            this.blacklistedBlocks.add(Material.matchMaterial((String)materialName));
        }
        for (String toolName : plugin.getConfig().getStringList("tools")) {
            if (Material.matchMaterial((String)toolName) == null) {
                plugin.getLogger().warning("Ignoring invalid material in allowed tools: " + toolName);
                continue;
            }
            this.spaTools.add(Material.matchMaterial((String)toolName));
        }
        if (!plugin.getConfig().isSet("monitorWorldChanges")) {
            plugin.getConfig().set("monitorWorldChanges", (Object)true);
        }
        this.monitorWorldChanges = plugin.getConfig().getBoolean("monitorWorldChanges", true);
        if (!plugin.getConfig().isSet("overrideWorldEdit")) {
            plugin.getConfig().set("overrideWorldEdit", (Object)false);
        }
        this.overrideWorldEdit = plugin.getConfig().getBoolean("overrideWorldEdit", false);
        plugin.saveConfig();
    }

    public boolean isBlacklisted(Material material) {
        return this.blacklistedBlocks.contains(material);
    }

    public boolean isMonitorWorldChanges() {
        return this.monitorWorldChanges;
    }

    public boolean isOverrideWorldEdit() {
        return this.overrideWorldEdit;
    }

    public boolean isSpaTool(Material material) {
        return this.spaTools.contains(material);
    }
}

