/*
 * Decompiled with CFR 0.152.
 */
package eu.internetpolice.spa.manager;

import eu.internetpolice.spa.SuperpickaxeReloaded;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class SpaManager {
    private final SuperpickaxeReloaded plugin;
    private final Set<UUID> spaEnabled = new HashSet<UUID>();

    public SpaManager(SuperpickaxeReloaded plugin) {
        this.plugin = plugin;
    }

    public void close() {
        this.clearSpaEnabled();
    }

    public void clearSpaEnabled() {
        this.spaEnabled.clear();
    }

    public void enableSpa(Player player, boolean sendMessage) {
        this.spaEnabled.add(player.getUniqueId());
        if (sendMessage) {
            player.sendMessage(ChatColor.GOLD + "Superpickaxe " + ChatColor.RED + "enabled" + ChatColor.GOLD + " for " + player.getDisplayName());
        }
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("NoCheatPlus")) {
            this.plugin.getNoCheatManager().exPlayer(player);
        }
    }

    public void disableSpa(Player player, boolean sendMessage) {
        this.spaEnabled.remove(player.getUniqueId());
        if (sendMessage) {
            player.sendMessage(ChatColor.GOLD + "Superpickaxe " + ChatColor.RED + "disabled" + ChatColor.GOLD + " for " + player.getDisplayName());
        }
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("NoCheatPlus")) {
            this.plugin.getNoCheatManager().unExPlayer(player);
        }
    }

    public boolean hasSpaMaterialPermission(Player player, Material material) {
        return player.hasPermission("spa." + material.name());
    }

    public boolean hasSpaUsePermission(Player player) {
        return player.hasPermission("spa.use");
    }

    public boolean isSpaEnabled(Player player) {
        return this.spaEnabled.contains(player.getUniqueId());
    }

    public boolean toggleSpa(Player player, boolean sendMessage) {
        if (this.isSpaEnabled(player)) {
            this.disableSpa(player, sendMessage);
            return false;
        }
        this.enableSpa(player, sendMessage);
        return true;
    }
}

