/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.common.factory;

import java.util.function.Function;
import java.util.function.Supplier;
import net.onestorm.library.common.context.BuildContext;

public interface Builder<P> {
    public String getName();

    public P build(BuildContext var1);

    public static <P> Builder<P> of(final String name, final Function<BuildContext, P> function) {
        return new Builder<P>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public P build(BuildContext context) {
                return function.apply(context);
            }
        };
    }

    public static <P> Builder<P> of(final String name, final Supplier<P> supplier) {
        return new Builder<P>(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public P build(BuildContext context) {
                return supplier.get();
            }
        };
    }
}

