/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.common.factory;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.common.factory.Builder;
import net.onestorm.library.common.factory.Factory;
import net.onestorm.library.storage.StorageMap;

public class GenericFactory<P>
implements Factory<P> {
    private final Map<String, Builder<P>> builderMap = new HashMap<String, Builder<P>>();

    @Override
    public P build(StorageMap storage) {
        P product;
        Optional optionalName = storage.getString("name");
        if (optionalName.isEmpty()) {
            throw new BuildException("Missing \"name\" key in storage while building.");
        }
        String name = ((String)optionalName.get()).toLowerCase(Locale.ENGLISH);
        Builder<P> builder = this.builderMap.get(name);
        if (builder == null) {
            throw new BuildException("Could not find a builder with the name: " + name);
        }
        try {
            product = builder.build(storage);
        }
        catch (Exception e) {
            throw new BuildException("Uncaught error while building a product: " + name, e);
        }
        return product;
    }

    @Override
    public void registerBuilder(Builder<P> builder) {
        String name = builder.getName().toLowerCase(Locale.ENGLISH);
        if (this.builderMap.containsKey(name)) {
            throw new IllegalArgumentException("There already exists a builder with this name: " + name);
        }
        this.builderMap.put(name, builder);
    }

    @Override
    public void unregisterBuilder(Builder<P> builder) {
        String name = builder.getName().toLowerCase(Locale.ENGLISH);
        this.builderMap.remove(name);
    }
}

