/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.configuration.file.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.onestorm.library.configuration.file.FileConfiguration;
import net.onestorm.library.configuration.file.MemorySection;
import net.onestorm.library.configuration.file.json.SectionDeserializer;
import net.onestorm.library.configuration.file.json.SectionSerializer;

public class JsonConfiguration
extends FileConfiguration {
    private static final Type MAP_TYPE = new TypeToken<ConcurrentHashMap<String, Object>>(){}.getType();
    private final Gson gson;

    public JsonConfiguration() {
        GsonBuilder builder = new GsonBuilder();
        builder.disableHtmlEscaping();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter(MAP_TYPE, (Object)new SectionDeserializer(this));
        builder.registerTypeAdapter(MemorySection.class, (Object)new SectionSerializer());
        this.gson = builder.create();
    }

    @Override
    protected void loadFromString(String data) {
        this.map = (Map)this.gson.fromJson(data, MAP_TYPE);
    }

    @Override
    protected String saveToString() {
        return this.gson.toJson((Object)this.map, MAP_TYPE);
    }
}

