/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.menu.build;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.onestorm.library.configuration.Section;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.build.MenuBuilder;
import net.onestorm.library.menu.build.MenuManager;
import net.onestorm.library.menu.exception.BuildMenuException;

public class MenuManagerImpl
implements MenuManager {
    private final Map<String, MenuBuilder> builderMap = new HashMap<String, MenuBuilder>();

    @Override
    public Menu createMenu(Section section) {
        Menu menu;
        Optional optionalName = section.getString("name");
        if (optionalName.isEmpty()) {
            throw new BuildMenuException("Missing \"name\" key in configuration");
        }
        String name = (String)optionalName.get();
        MenuBuilder builder = this.builderMap.get(name);
        if (builder == null) {
            throw new IllegalArgumentException("Could not find a builder for Menu: " + name);
        }
        try {
            menu = builder.build(section);
        }
        catch (Exception e) {
            throw new BuildMenuException("Uncaught error while building an Action: " + name, e);
        }
        return menu;
    }

    @Override
    public void registerBuilder(MenuBuilder builder) {
        String name = builder.getName().toLowerCase(Locale.ENGLISH);
        if (this.builderMap.containsKey(name)) {
            throw new IllegalArgumentException("There already exists a builder with this name: " + name);
        }
        this.builderMap.put(name, builder);
    }

    @Override
    public void unregisterBuilder(MenuBuilder builder) {
        String name = builder.getName().toLowerCase(Locale.ENGLISH);
        this.builderMap.remove(name);
    }
}

