/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.menu;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.menu.element.IdentifiableElement;

public abstract class AbstractMenu
implements Menu {
    private String title;
    private final List<Element> elementList = new ArrayList<Element>();

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public List<Element> getElements() {
        return this.elementList;
    }

    @Override
    public List<Element> getElementsByName(String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : this.elementList) {
            if (!element.getName().equalsIgnoreCase(name)) continue;
            result.add(element);
        }
        return result;
    }

    @Override
    public Optional<Element> getElementById(String identifier) {
        Element result = null;
        for (Element element : this.elementList) {
            IdentifiableElement IdentifiableElement2;
            Optional<String> optionalId;
            if (!(element instanceof IdentifiableElement) || (optionalId = (IdentifiableElement2 = (IdentifiableElement)((Object)element)).getIdentifier()).isEmpty() || !optionalId.get().equalsIgnoreCase(identifier)) continue;
            result = element;
            break;
        }
        return Optional.ofNullable(result);
    }

    @Override
    public void addElement(Element element) {
        this.elementList.add(element);
    }

    @Override
    public void removeElement(Element element) {
        this.elementList.remove(element);
    }

    @Override
    public void removeElementById(String identifier) {
        this.elementList.removeIf(element -> {
            if (!(element instanceof IdentifiableElement)) {
                return false;
            }
            IdentifiableElement identifierElement = (IdentifiableElement)((Object)element);
            Optional<String> optionalId = identifierElement.getIdentifier();
            return optionalId.isPresent() && optionalId.get().equalsIgnoreCase(identifier);
        });
    }
}

