/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.menu.build;

import java.util.Optional;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.common.factory.Builder;
import net.onestorm.library.common.factory.Factory;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.storage.StorageMap;

public abstract class AbstractMenuBuilder
implements Builder<Menu> {
    protected final Factory<Element> elementFactory;

    protected AbstractMenuBuilder(Factory<Element> elementFactory) {
        this.elementFactory = elementFactory;
    }

    public Menu build(StorageMap storage) {
        Menu menu = this.createMenu(storage);
        Optional optionalElementMap = storage.getMap("elements");
        if (optionalElementMap.isEmpty()) {
            return menu;
        }
        StorageMap elementMap = (StorageMap)optionalElementMap.get();
        elementMap.forEach((key, value) -> {
            Element element;
            if (!(value instanceof StorageMap)) {
                return;
            }
            StorageMap storageMap = (StorageMap)value;
            try {
                element = (Element)this.elementFactory.build(storageMap);
            }
            catch (BuildException e) {
                return;
            }
            menu.addElement(element);
        });
        return menu;
    }

    protected abstract Menu createMenu(StorageMap var1);
}

