/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.menu.build;

import java.util.Optional;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.common.factory.Builder;
import net.onestorm.library.common.factory.Factory;
import net.onestorm.library.common.factory.context.BuildContext;
import net.onestorm.library.common.factory.context.StorageBuildContext;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.menu.element.build.context.ElementBuildContext;
import net.onestorm.library.storage.StorageMap;

public abstract class AbstractMenuBuilder
implements Builder<Menu> {
    protected final Factory<Element> elementFactory;

    protected AbstractMenuBuilder(Factory<Element> elementFactory) {
        this.elementFactory = elementFactory;
    }

    public Menu build(BuildContext context) {
        if (!(context instanceof StorageBuildContext)) {
            throw new BuildException("Context is not an instance of StorageBuildContext.");
        }
        StorageBuildContext storageContext = (StorageBuildContext)context;
        StorageMap storage = storageContext.getStorage();
        Menu menu = this.createMenu(storage);
        storage.getString("title").ifPresent(menu::setTitle);
        Optional optionalElementMap = storage.getMap("elements");
        if (optionalElementMap.isEmpty()) {
            return menu;
        }
        StorageMap elementMap = (StorageMap)optionalElementMap.get();
        elementMap.forEach((key, value) -> {
            Element element;
            if (!(value instanceof StorageMap)) {
                return;
            }
            StorageMap elementStorage = (StorageMap)value;
            try {
                element = (Element)this.elementFactory.build((BuildContext)new ElementBuildContext(elementStorage, menu));
            }
            catch (BuildException e) {
                return;
            }
            menu.addElement(element);
        });
        return menu;
    }

    protected abstract Menu createMenu(StorageMap var1);
}

