/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.message;

import java.util.ArrayList;
import java.util.Collection;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.TagPattern;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.onestorm.library.message.MessageBuilder;
import org.jetbrains.annotations.NotNull;

public class MessageBuilderImpl
implements MessageBuilder {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private String message;
    private String defaultMessage = "";
    private final Collection<TagResolver> tagResolvers = new ArrayList<TagResolver>();

    public MessageBuilderImpl() {
    }

    public MessageBuilderImpl(String message) {
        this.message = message;
    }

    @Override
    public MessageBuilder withMessage(String message) {
        this.message = message;
        return this;
    }

    @Override
    public MessageBuilder withDefault(String message) {
        this.defaultMessage = message;
        return this;
    }

    @Override
    public MessageBuilder withTagResolver(TagResolver resolver) {
        this.tagResolvers.add(resolver);
        return this;
    }

    @Override
    public MessageBuilder withPlaceholder(@TagPattern String key, String value) {
        return this.withPlaceholder(key, (Component)Component.text((String)value));
    }

    @Override
    public MessageBuilder withPlaceholder(@TagPattern String key, Component value) {
        this.tagResolvers.add((TagResolver)Placeholder.component((String)key, (ComponentLike)value));
        return this;
    }

    @Override
    public Component build() {
        String finalMessage = this.message;
        if (this.message == null) {
            if (this.defaultMessage == null) {
                throw new IllegalArgumentException("message and defaultMessage are null");
            }
            finalMessage = this.defaultMessage;
        }
        return MINI_MESSAGE.deserialize(finalMessage, TagResolver.resolver(this.tagResolvers));
    }

    @NotNull
    public Component asComponent() {
        return this.build();
    }
}

