/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.cost;

import net.onestorm.library.cost.Refundable;
import net.onestorm.library.paper.context.PlayerContext;
import net.onestorm.library.paper.cost.PaperCost;
import net.onestorm.library.paper.cost.PaperRefundable;
import org.bukkit.entity.Player;

public class ExperienceLevelCost
extends PaperCost {
    private static final String COST_NAME = "experience-level";
    private final int level;

    public ExperienceLevelCost(int level) {
        this.level = level;
    }

    public String getName() {
        return COST_NAME;
    }

    @Override
    public boolean canPay(PlayerContext context) {
        Player player = context.getPlayer();
        return player.getLevel() >= this.level;
    }

    @Override
    public Refundable pay(PlayerContext context) {
        Player player = context.getPlayer();
        if (player.getLevel() < this.level) {
            throw new IllegalStateException("Insufficient experience levels for " + player.getName());
        }
        player.giveExpLevels(-this.level);
        return new PaperRefundable(){

            @Override
            public void refund(PlayerContext context) {
                context.getPlayer().giveExpLevels(ExperienceLevelCost.this.level);
            }
        };
    }
}

