/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.menu;

import net.kyori.adventure.text.Component;
import net.onestorm.library.paper.menu.PaperMenu;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public class MenuHolder
implements InventoryHolder {
    private final PaperMenu menu;
    private final Inventory inventory;
    private final Component title;
    private boolean isInvalidated = false;

    public MenuHolder(PaperMenu menu, InventoryType type) {
        this.menu = menu;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (InventoryType)type);
        this.title = type.defaultTitle();
    }

    public MenuHolder(PaperMenu menu, InventoryType type, Component title) {
        this.menu = menu;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (InventoryType)type, (Component)title);
        this.title = title;
    }

    public MenuHolder(PaperMenu menu, int size) {
        this.menu = menu;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size);
        this.title = InventoryType.CHEST.defaultTitle();
    }

    public MenuHolder(PaperMenu menu, int size, Component title) {
        this.menu = menu;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)title);
        this.title = title;
    }

    public Component getTitle() {
        return this.title;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public PaperMenu getMenu() {
        return this.menu;
    }

    public boolean isInvalidated() {
        return this.isInvalidated;
    }

    public void invalidate() {
        this.isInvalidated = true;
        this.inventory.clear();
    }
}

