/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.menu.element.ElementMenu;
import net.onestorm.library.menu.element.Identifiable;
import net.onestorm.library.menu.slot.Slot;
import net.onestorm.library.paper.menu.PaperSlot;
import net.onestorm.library.user.OnlineUser;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PaperElementMenu
implements ElementMenu,
InventoryHolder {
    private Inventory inventory = null;
    private final List<Element> elementList = new ArrayList<Element>();
    private final Map<Integer, Element> elementMap = new HashMap<Integer, Element>();

    public void open(OnlineUser user) {
    }

    public List<Element> getElements() {
        return this.elementList;
    }

    public List<Element> getElements(String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : this.elementList) {
            if (!element.getName().equalsIgnoreCase(name)) continue;
            result.add(element);
        }
        return result;
    }

    public Optional<Element> getElement(String id) {
        Element result = null;
        for (Element element : this.elementList) {
            Identifiable identifierElement;
            Optional optionalId;
            if (!(element instanceof Identifiable) || (optionalId = (identifierElement = (Identifiable)element).getIdentifier()).isEmpty() || !((String)optionalId.get()).equalsIgnoreCase(id)) continue;
            result = element;
            break;
        }
        return Optional.ofNullable(result);
    }

    public void addElement(Element element) {
        this.elementList.add(element);
    }

    public void removeElement(Element element) {
        this.elementList.remove(element);
    }

    public void removeElement(String id) {
        this.elementList.removeIf(element -> {
            if (!(element instanceof Identifiable)) {
                return false;
            }
            Identifiable identifierElement = (Identifiable)element;
            Optional optionalId = identifierElement.getIdentifier();
            return optionalId.isPresent() && ((String)optionalId.get()).equalsIgnoreCase(id);
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Inventory getInventory() {
        if (this.inventory != null) {
            return this.inventory;
        }
        int size = 54;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)Component.text((String)"TEST MENU"));
        for (Element element : this.elementList) {
            Iterator iterator = element.getSlotIndexes().iterator();
            while (iterator.hasNext()) {
                int slotIndex = (Integer)iterator.next();
                if (slotIndex < 0 || slotIndex > size) continue;
                this.elementMap.put(slotIndex, element);
            }
        }
        for (Map.Entry entry : this.elementMap.entrySet()) {
            void slot;
            int slotIndex = (Integer)entry.getKey();
            Element element = (Element)entry.getValue();
            Slot slot2 = element.getSlot(slotIndex);
            if (!(slot2 instanceof PaperSlot)) {
                this.inventory.addItem(new ItemStack[]{new ItemStack(Material.AIR)});
                continue;
            }
            PaperSlot slot22 = (PaperSlot)slot2;
            this.inventory.addItem(new ItemStack[]{slot.getItemStack()});
        }
        return this.inventory;
    }
}

