/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.action;

import java.util.Locale;
import java.util.Optional;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.onestorm.library.action.Action;
import net.onestorm.library.action.ActionBuilder;
import net.onestorm.library.paper.action.PlaySoundAction;
import net.onestorm.library.storage.StorageMap;
import org.bukkit.Server;

public class PlaySoundActionBuilder
implements ActionBuilder {
    private static final String ACTION_BUILDER_NAME = "play-sound";
    private final Server server;

    public PlaySoundActionBuilder(Server server) {
        this.server = server;
    }

    public String getName() {
        return ACTION_BUILDER_NAME;
    }

    public Action build(StorageMap storage) {
        Sound.Source source;
        Optional optionalSound = storage.getString("sound");
        if (optionalSound.isEmpty()) {
            throw new IllegalArgumentException("Missing \"sound\" key in configuration");
        }
        String scope = storage.getString("scope").orElse("player");
        String namespace = storage.getString("namespace").orElse("minecraft");
        String sourceName = storage.getString("source").orElse("PLAYER");
        float volume = storage.getFloat("volume").orElse(Float.valueOf(1.0f)).floatValue();
        float pitch = storage.getFloat("pitch").orElse(Float.valueOf(1.0f)).floatValue();
        try {
            source = Sound.Source.valueOf((String)sourceName.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            source = Sound.Source.PLAYER;
        }
        Sound sound = Sound.sound((Key)Key.key((String)namespace, (String)((String)optionalSound.get())), (Sound.Source)source, (float)volume, (float)pitch);
        return new PlaySoundAction(this.server, scope, sound);
    }
}

