/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.menu.element;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.cell.Cell;
import net.onestorm.library.paper.menu.cell.ItemStackCell;
import net.onestorm.library.paper.menu.cell.ItemStackCellImpl;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ElementContent
implements Iterable<ItemStackCell> {
    private final Menu menu;
    private final Map<Integer, ItemStackCell> cellMap = new HashMap<Integer, ItemStackCell>();

    public ElementContent(Menu menu) {
        this.menu = menu;
    }

    public Cell setItem(int index, ItemStack itemStack) {
        ItemStackCell cell = this.cellMap.get(index);
        if (cell == null) {
            cell = new ItemStackCellImpl(this.menu, index, itemStack);
            this.cellMap.put(index, cell);
        } else {
            cell.setItemStack(itemStack);
        }
        return cell;
    }

    public Cell setItem(int x, int y, ItemStack itemStack) {
        int index = this.calculateIndex(x, y, this.menu.getWidth());
        return this.setItem(index, itemStack);
    }

    private int calculateIndex(int x, int y, int width) {
        return y * width + x;
    }

    @Override
    @NotNull
    public Iterator<ItemStackCell> iterator() {
        return this.cellMap.values().iterator();
    }
}

