/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.menu.element.ElementMenu;
import net.onestorm.library.menu.element.Identifiable;
import net.onestorm.library.paper.user.PaperUser;
import net.onestorm.library.user.OnlineUser;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PaperElementMenu
implements ElementMenu<ItemStack>,
InventoryHolder {
    private Inventory inventory = null;
    private final List<Element<ItemStack>> elementList = new ArrayList<Element<ItemStack>>();
    private final Map<Integer, Element<ItemStack>> elementMap = new HashMap<Integer, Element<ItemStack>>();

    public void open(OnlineUser user) {
        if (user instanceof PaperUser) {
            PaperUser paperUser = (PaperUser)user;
            paperUser.asPlayer().openInventory(this.getInventory());
        }
    }

    public List<Element<ItemStack>> getElements() {
        return this.elementList;
    }

    public List<Element<ItemStack>> getElements(String name) {
        ArrayList<Element<ItemStack>> result = new ArrayList<Element<ItemStack>>();
        for (Element<ItemStack> element : this.elementList) {
            if (!element.getName().equalsIgnoreCase(name)) continue;
            result.add(element);
        }
        return result;
    }

    public Optional<Element<ItemStack>> getElement(String id) {
        Element<ItemStack> result = null;
        for (Element<ItemStack> element : this.elementList) {
            Identifiable identifierElement;
            Optional optionalId;
            if (!(element instanceof Identifiable) || (optionalId = (identifierElement = (Identifiable)element).getIdentifier()).isEmpty() || !((String)optionalId.get()).equalsIgnoreCase(id)) continue;
            result = element;
            break;
        }
        return Optional.ofNullable(result);
    }

    public void addElement(Element<ItemStack> element) {
        this.elementList.add(element);
    }

    public void removeElement(Element<ItemStack> element) {
        this.elementList.remove(element);
    }

    public void removeElement(String id) {
        this.elementList.removeIf(element -> {
            if (!(element instanceof Identifiable)) {
                return false;
            }
            Identifiable identifierElement = (Identifiable)element;
            Optional optionalId = identifierElement.getIdentifier();
            return optionalId.isPresent() && ((String)optionalId.get()).equalsIgnoreCase(id);
        });
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory != null) {
            return this.inventory;
        }
        int size = 54;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)size, (Component)Component.text((String)"TEST MENU"));
        for (Element<ItemStack> element : this.elementList) {
            Iterator iterator = element.getSlots().iterator();
            while (iterator.hasNext()) {
                int slotIndex = (Integer)iterator.next();
                if (slotIndex < 0 || slotIndex > size) continue;
                this.elementMap.put(slotIndex, element);
            }
        }
        for (Map.Entry entry : this.elementMap.entrySet()) {
            int slotIndex = (Integer)entry.getKey();
            Element element = (Element)entry.getValue();
            ItemStack item = (ItemStack)element.getItem(slotIndex);
            if (item == null) {
                this.inventory.setItem(slotIndex, new ItemStack(Material.AIR));
                continue;
            }
            this.inventory.setItem(slotIndex, item);
        }
        return this.inventory;
    }
}

