/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.menu.listener;

import net.onestorm.library.menu.ClickableMenu;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.MenuClickEvent;
import net.onestorm.library.paper.menu.MenuInventoryHolder;
import net.onestorm.library.paper.menu.PaperMenuClickEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class MenuListener
implements Listener {
    private final JavaPlugin plugin;

    public MenuListener(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof MenuInventoryHolder)) {
            return;
        }
        MenuInventoryHolder menuInventoryHolder = (MenuInventoryHolder)holder;
        event.setCancelled(true);
        if (!menuInventoryHolder.isValid()) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> ((Inventory)inventory).close());
            return;
        }
        Menu menu = menuInventoryHolder.getMenu();
        if (!(menu instanceof ClickableMenu)) {
            return;
        }
        ClickableMenu clickableMenu = (ClickableMenu)menu;
        clickableMenu.onMenuClick((MenuClickEvent)new PaperMenuClickEvent(event, menu));
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Inventory inventory = event.getInventory();
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof MenuInventoryHolder)) {
            return;
        }
        MenuInventoryHolder menuInventoryHolder = (MenuInventoryHolder)holder;
        event.setCancelled(true);
        if (!menuInventoryHolder.isValid()) {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> ((Inventory)inventory).close());
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        this.onInventoryClose(event.getPlayer());
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.onInventoryClose(event.getPlayer());
    }

    @EventHandler
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        this.onInventoryClose(event.getPlayer());
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.onInventoryClose(event.getPlayer());
    }

    private void onInventoryClose(Player player) {
        Inventory inventory = player.getOpenInventory().getTopInventory();
        InventoryHolder holder = inventory.getHolder();
        if (!(holder instanceof MenuInventoryHolder)) {
            return;
        }
        MenuInventoryHolder menuInventoryHolder = (MenuInventoryHolder)holder;
        if (!menuInventoryHolder.isValid()) {
            return;
        }
        menuInventoryHolder.invalidate();
    }
}

