/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.onestorm.library.menu.ClickableMenu;
import net.onestorm.library.menu.ElementMenu;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.MenuClickEvent;
import net.onestorm.library.menu.element.ClickableElement;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.menu.element.IdentifiableElement;
import net.onestorm.library.paper.menu.MenuInventoryHolder;
import net.onestorm.library.paper.user.PaperOnlineUser;
import net.onestorm.library.user.OnlineUser;
import org.bukkit.inventory.ItemStack;

public class PaperElementMenu
implements ElementMenu<ItemStack>,
ClickableMenu<ItemStack> {
    private static final int MENU_WIDTH = 9;
    private PaperOnlineUser owner = null;
    private MenuInventoryHolder inventoryHolder;
    private Component title;
    private final int height;
    private Component newTitle = null;
    private final List<Element<ItemStack>> elementList = new ArrayList<Element<ItemStack>>();
    private final Map<Integer, Element<ItemStack>> elementMap = new HashMap<Integer, Element<ItemStack>>();

    public PaperElementMenu(Component title, int height) {
        this.height = height > 6 ? 6 : (height < 1 ? 1 : height);
        this.title = title;
    }

    public void open(OnlineUser user) {
        if (!(user instanceof PaperOnlineUser)) {
            throw new IllegalArgumentException("Not a paper user");
        }
        PaperOnlineUser paperUser = (PaperOnlineUser)user;
        this.owner = paperUser;
        this.inventoryHolder = new MenuInventoryHolder(this.height, this.title, (Menu)this);
        this.setContent();
        paperUser.asPlayer().openInventory(this.inventoryHolder.getInventory());
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.newTitle = title;
    }

    public void update() {
        if (this.inventoryHolder == null || !this.inventoryHolder.isValid()) {
            return;
        }
        if (this.newTitle.equals((Object)this.title)) {
            this.setContent();
        } else {
            this.inventoryHolder.invalidate();
            this.title = this.newTitle;
            this.inventoryHolder = new MenuInventoryHolder(this.height, this.title, (Menu)this);
            this.setContent();
            this.owner.asPlayer().openInventory(this.inventoryHolder.getInventory());
        }
    }

    private void setContent() {
        ItemStack[] content = new ItemStack[this.height * 9];
        for (Element<ItemStack> element : this.elementList) {
            element.getItems((OnlineUser)this.owner).forEach((slot, item) -> {
                if (slot < 0 || slot > this.height * 9) {
                    return;
                }
                this.elementMap.put((Integer)slot, element);
                content[slot.intValue()] = item;
            });
        }
        this.inventoryHolder.getInventory().setContents(content);
    }

    public List<Element<ItemStack>> getElements() {
        return this.elementList;
    }

    public List<Element<ItemStack>> getElements(String name) {
        ArrayList<Element<ItemStack>> result = new ArrayList<Element<ItemStack>>();
        for (Element<ItemStack> element : this.elementList) {
            if (!element.getName().equalsIgnoreCase(name)) continue;
            result.add(element);
        }
        return result;
    }

    public Optional<Element<ItemStack>> getElement(String id) {
        Element<ItemStack> result = null;
        for (Element<ItemStack> element : this.elementList) {
            IdentifiableElement identifierElement;
            Optional optionalId;
            if (!(element instanceof IdentifiableElement) || (optionalId = (identifierElement = (IdentifiableElement)element).getIdentifier()).isEmpty() || !((String)optionalId.get()).equalsIgnoreCase(id)) continue;
            result = element;
            break;
        }
        return Optional.ofNullable(result);
    }

    public void addElement(Element<ItemStack> element) {
        this.elementList.add(element);
    }

    public void removeElement(Element<ItemStack> element) {
        this.elementList.remove(element);
    }

    public void removeElement(String id) {
        this.elementList.removeIf(element -> {
            if (!(element instanceof IdentifiableElement)) {
                return false;
            }
            IdentifiableElement identifierElement = (IdentifiableElement)element;
            Optional optionalId = identifierElement.getIdentifier();
            return optionalId.isPresent() && ((String)optionalId.get()).equalsIgnoreCase(id);
        });
    }

    public void onMenuClick(MenuClickEvent<ItemStack> event) {
        Element<ItemStack> element = this.elementMap.get(event.getSlot());
        if (!(element instanceof ClickableElement)) {
            return;
        }
        ClickableElement clickableElement = (ClickableElement)element;
        clickableElement.onElementClick(event);
    }
}

