/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.menu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.menu.element.IdentifiableElement;
import net.onestorm.library.menu.slot.Slot;
import net.onestorm.library.paper.menu.MenuInventoryHolder;
import net.onestorm.library.paper.menu.element.ClickableElement;
import net.onestorm.library.paper.menu.slot.ItemStackSlot;
import net.onestorm.library.paper.user.PaperOnlineUser;
import net.onestorm.library.user.OnlineUser;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public abstract class PaperMenu
implements Menu {
    private MenuInventoryHolder inventoryHolder = null;
    private PaperOnlineUser owner = null;
    private Map<String, Object> options;
    private Component currentTitle;
    private Component title;
    private final List<Element> elementList = new ArrayList<Element>();
    private final Map<Integer, Element> elementMap = new HashMap<Integer, Element>();
    private final Map<Integer, Slot> slotMap = new HashMap<Integer, Slot>();

    public void open(OnlineUser user) {
        this.open(user, new HashMap<String, Object>());
    }

    public void open(OnlineUser user, Map<String, Object> options) {
        if (!(user instanceof PaperOnlineUser)) {
            throw new IllegalArgumentException("Cannot open menu, user is not a paper user.");
        }
        PaperOnlineUser paperUser = (PaperOnlineUser)user;
        this.owner = paperUser;
        this.options = options;
        this.currentTitle = this.title;
        this.inventoryHolder = this.createNewHolder();
        this.setContent();
        paperUser.asPlayer().openInventory(this.inventoryHolder.getInventory());
    }

    public void update() {
        if (this.inventoryHolder == null || !this.inventoryHolder.isValid()) {
            return;
        }
        if (this.title.equals((Object)this.currentTitle)) {
            this.setContent();
        } else {
            this.inventoryHolder.invalidate();
            this.currentTitle = this.title;
            this.inventoryHolder = this.createNewHolder();
            this.setContent();
            this.owner.asPlayer().openInventory(this.inventoryHolder.getInventory());
        }
    }

    private void setContent() {
        int contentSize = this.inventoryHolder.getInventory().getSize();
        ItemStack[] content = new ItemStack[contentSize];
        for (Element element : this.elementList) {
            element.getSlots((Menu)this).forEach((index, slot) -> {
                if (index < 0 || index >= contentSize) {
                    return;
                }
                this.elementMap.put((Integer)index, element);
                this.slotMap.put((Integer)index, (Slot)slot);
                if (!(slot instanceof ItemStackSlot)) {
                    content[index.intValue()] = new ItemStack(Material.AIR);
                    return;
                }
                ItemStackSlot itemStackSlot = (ItemStackSlot)slot;
                content[index.intValue()] = itemStackSlot.getItemStack();
            });
        }
        this.inventoryHolder.getInventory().setContents(content);
    }

    public void updateSlot(ItemStackSlot slot) {
        Slot currentSlot = this.slotMap.get(slot.getIndex());
        if (slot != currentSlot) {
            return;
        }
        this.inventoryHolder.getInventory().setItem(slot.getIndex(), slot.getItemStack());
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.title = title;
    }

    public OnlineUser getOwner() {
        return this.owner;
    }

    public List<Element> getElements() {
        return this.elementList;
    }

    public List<Element> getElements(String name) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element element : this.elementList) {
            if (!element.getName().equalsIgnoreCase(name)) continue;
            result.add(element);
        }
        return result;
    }

    public Optional<Element> getElement(String id) {
        Element result = null;
        for (Element element : this.elementList) {
            IdentifiableElement identifierElement;
            Optional optionalId;
            if (!(element instanceof IdentifiableElement) || (optionalId = (identifierElement = (IdentifiableElement)element).getIdentifier()).isEmpty() || !((String)optionalId.get()).equalsIgnoreCase(id)) continue;
            result = element;
            break;
        }
        return Optional.ofNullable(result);
    }

    public void addElement(Element element) {
        this.elementList.add(element);
    }

    public void removeElement(Element element) {
        this.elementList.remove(element);
    }

    public void removeElement(String id) {
        this.elementList.removeIf(element -> {
            if (!(element instanceof IdentifiableElement)) {
                return false;
            }
            IdentifiableElement identifierElement = (IdentifiableElement)element;
            Optional optionalId = identifierElement.getIdentifier();
            return optionalId.isPresent() && ((String)optionalId.get()).equalsIgnoreCase(id);
        });
    }

    protected abstract MenuInventoryHolder createNewHolder();

    public void handleClick(InventoryClickEvent event) {
        Element element = this.elementMap.get(event.getSlot());
        if (!(element instanceof ClickableElement)) {
            return;
        }
        ClickableElement clickableElement = (ClickableElement)element;
        clickableElement.onClick(this, event.getSlot());
    }
}

