/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.menu.element.build;

import java.util.ArrayList;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.common.factory.Builder;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.paper.menu.element.ItemStackElement;
import net.onestorm.library.paper.util.ItemStackUtil;
import net.onestorm.library.storage.StorageMap;
import org.bukkit.inventory.ItemStack;

public class ItemStackElementBuilder
implements Builder<Element> {
    private static final String BUILDER_NAME = "stormlibrary:item-stack";
    private static final int DEFAULT_WIDTH = 1;
    private static final int DEFAULT_HEIGHT = 1;

    public String getName() {
        return BUILDER_NAME;
    }

    public Element build(StorageMap storage) {
        StorageMap itemMap = (StorageMap)storage.getMap("item-stack").orElseThrow(() -> new BuildException("Missing \"item-stack\" key in storage while building: stormlibrary:item-stack"));
        int x = (Integer)storage.getInteger("x").orElseThrow(() -> new BuildException("Missing \"x\" key in storage while building: stormlibrary:item-stack"));
        int y = (Integer)storage.getInteger("y").orElseThrow(() -> new BuildException("Missing \"y\" key in storage while building: stormlibrary:item-stack"));
        int width = storage.getInteger("width").orElse(1);
        int height = storage.getInteger("height").orElse(1);
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int indexY = y; indexY < y + height; ++indexY) {
            for (int indexX = x; indexX < x + width; ++indexX) {
                slots.add(indexY * 9 + indexX);
            }
        }
        ItemStack itemStack = ItemStackUtil.fromStorage(itemMap);
        return new ItemStackElement(slots, itemStack);
    }
}

