/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.menu.element;

import java.util.List;
import java.util.Optional;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.cell.Cell;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.menu.element.IdentifiableElement;
import net.onestorm.library.menu.element.PrioritizableElement;
import net.onestorm.library.paper.menu.element.ElementContent;
import org.bukkit.inventory.ItemStack;

public class ItemStackElement
implements Element,
IdentifiableElement,
PrioritizableElement {
    private static final String ELEMENT_NAME = "stormlibrary:item-stack";
    private List<Integer> slots;
    private ItemStack itemStack;
    private String identifier = null;
    private int priority = 0;

    public ItemStackElement(List<Integer> slots, ItemStack itemStack) {
        this.slots = slots;
        this.itemStack = itemStack;
    }

    public String getName() {
        return ELEMENT_NAME;
    }

    public Iterable<Cell> getContent(Menu menu) {
        ElementContent content = new ElementContent(menu);
        for (int slot : this.slots) {
            content.setItem(slot, this.itemStack);
        }
        return content;
    }

    public Optional<String> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public List<Integer> getSlots() {
        return this.slots;
    }

    public void setSlots(List<Integer> slots) {
        this.slots = slots;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }
}

