/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.menu;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.onestorm.library.menu.AbstractMenu;
import net.onestorm.library.menu.Menu;
import net.onestorm.library.menu.cell.Cell;
import net.onestorm.library.menu.element.CloseableElement;
import net.onestorm.library.menu.element.Element;
import net.onestorm.library.menu.element.ElementComparator;
import net.onestorm.library.paper.menu.MenuHolder;
import net.onestorm.library.paper.menu.cell.ItemStackCell;
import net.onestorm.library.paper.menu.element.ListenerElement;
import net.onestorm.library.paper.user.PaperUser;
import net.onestorm.library.user.User;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public abstract class PaperMenu
extends AbstractMenu {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final Comparator<Element> ELEMENT_COMPARATOR = new ElementComparator();
    private MenuHolder menuHolder;
    private Component currentTitle;
    private PaperUser owner = null;
    private Map<String, Object> options;
    private final Map<Integer, Element> elementMap = new HashMap<Integer, Element>();
    private final Map<Integer, Cell> cellMap = new HashMap<Integer, Cell>();

    public void open(User user) {
        this.open(user, new HashMap<String, Object>());
    }

    public void open(User user, Map<String, Object> options) {
        if (this.menuHolder != null) {
            throw new IllegalStateException("Menu was already opened!");
        }
        if (!(user instanceof PaperUser)) {
            throw new IllegalArgumentException("Cannot open menu, user is not a paper user.");
        }
        PaperUser paperUser = (PaperUser)user;
        this.owner = paperUser;
        this.options = options;
        this.menuHolder = this.createMenuHolder();
        this.setContent();
        paperUser.asPlayer().openInventory(this.menuHolder.getInventory());
    }

    public void update() {
        if (this.menuHolder == null || this.menuHolder.isInvalidated()) {
            return;
        }
        Component title = this.createTitle();
        if (title != null && !title.equals(this.currentTitle)) {
            this.menuHolder.invalidate();
            this.menuHolder = this.createMenuHolder();
            this.currentTitle = title;
            this.setContent();
            this.owner.asPlayer().openInventory(this.menuHolder.getInventory());
        } else {
            this.setContent();
        }
    }

    private void setContent() {
        int contentSize = this.getSize();
        ItemStack[] content = new ItemStack[contentSize];
        List elementList = this.getElements();
        elementList.sort(ELEMENT_COMPARATOR);
        for (Element element : elementList) {
            element.getContent((Menu)this).forEach(cell -> {
                int index = cell.getIndex();
                if (index < 0 || index >= contentSize) {
                    return;
                }
                this.elementMap.put(index, element);
                this.cellMap.put(index, (Cell)cell);
                if (!(cell instanceof ItemStackCell)) {
                    content[index] = new ItemStack(Material.AIR);
                    return;
                }
                ItemStackCell itemStackCell = (ItemStackCell)cell;
                content[index] = itemStackCell.getItemStack();
            });
        }
        this.menuHolder.getInventory().setContents(content);
    }

    public void updateCell(Cell cell) {
        if (this.menuHolder == null || this.menuHolder.isInvalidated()) {
            return;
        }
        int index = cell.getIndex();
        Cell currentCell = this.cellMap.get(cell.getIndex());
        if (cell != currentCell) {
            return;
        }
        if (!(cell instanceof ItemStackCell)) {
            return;
        }
        ItemStackCell itemStackCell = (ItemStackCell)cell;
        this.menuHolder.getInventory().setItem(index, itemStackCell.getItemStack());
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public User getOwner() {
        return this.owner;
    }

    public void close() {
        if (this.menuHolder == null) {
            return;
        }
        this.menuHolder.getInventory().close();
    }

    public Component createTitle() {
        return MINI_MESSAGE.deserialize(this.getTitle(), TagResolver.resolver((Iterable)this.tagResolvers));
    }

    protected abstract MenuHolder createMenuHolder();

    @ApiStatus.Internal
    public MenuHolder getMenuHolder() {
        return this.menuHolder;
    }

    public void onClick(InventoryClickEvent event) {
        for (Element element : this.getElements()) {
            if (!(element instanceof ListenerElement)) continue;
            ListenerElement listenerElement = (ListenerElement)element;
            listenerElement.onInventoryClick(event, this);
        }
        if (event.getClickedInventory() != event.getView().getTopInventory()) {
            return;
        }
        Element element = this.elementMap.get(event.getSlot());
        if (element instanceof ListenerElement) {
            ListenerElement listenerElement = (ListenerElement)element;
            listenerElement.onClick(event, this);
        }
    }

    public void onClose() {
        for (Element element : this.getElements()) {
            if (!(element instanceof CloseableElement)) continue;
            CloseableElement closeableElement = (CloseableElement)element;
            closeableElement.close((Menu)this);
        }
    }
}

