/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.util;

import java.util.ArrayList;
import java.util.Locale;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.storage.StorageMap;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ItemStackUtil {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final int DEFAULT_AMOUNT = 1;

    private ItemStackUtil() {
    }

    public static ItemStack fromStorage(StorageMap storage) {
        Material material;
        String materialString = (String)storage.getString("material").orElseThrow(() -> new BuildException("Missing \"material\" key in storage"));
        try {
            material = Material.valueOf((String)materialString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new BuildException("Could not find a material with the name: " + materialString);
        }
        int amount = storage.getInteger("amount").orElse(1);
        ItemStack item = new ItemStack(material, amount);
        storage.getString("display-name").ifPresent(displayName -> {
            Component displayNameComponent = MINI_MESSAGE.deserialize(displayName);
            item.editMeta(meta -> meta.displayName(displayNameComponent));
        });
        storage.getList("lore").ifPresent(storageList -> {
            ArrayList lore = new ArrayList();
            storageList.forEach(value -> {
                Component line;
                if (value instanceof String) {
                    String string = (String)value;
                    line = MINI_MESSAGE.deserialize((Object)string);
                } else if (value instanceof Number) {
                    Number number = (Number)value;
                    line = Component.text((String)String.valueOf(number));
                } else if (value instanceof Boolean) {
                    Boolean bool = (Boolean)value;
                    line = Component.text((boolean)bool);
                } else {
                    return;
                }
                lore.add(line);
            });
            item.editMeta(meta -> meta.lore(lore));
        });
        return item;
    }
}

