/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.paper.action;

import java.util.Optional;
import net.onestorm.library.action.Action;
import net.onestorm.library.common.factory.BuildException;
import net.onestorm.library.common.factory.Builder;
import net.onestorm.library.common.factory.context.BuildContext;
import net.onestorm.library.common.factory.context.StorageBuildContext;
import net.onestorm.library.paper.action.ConsoleCommandAction;
import net.onestorm.library.paper.action.PlayerCommandAction;
import net.onestorm.library.storage.StorageMap;
import org.bukkit.plugin.Plugin;

public class CommandActionBuilder
implements Builder<Action> {
    private static final String BUILDER_NAME = "command";
    private final Plugin plugin;

    public CommandActionBuilder(Plugin plugin) {
        this.plugin = plugin;
    }

    public String getName() {
        return BUILDER_NAME;
    }

    public Action build(BuildContext context) {
        if (!(context instanceof StorageBuildContext)) {
            throw new BuildException("Context is not an instance of StorageBuildContext.");
        }
        StorageBuildContext storageContext = (StorageBuildContext)context;
        StorageMap storage = storageContext.getStorage();
        String command = (String)storage.getString(BUILDER_NAME).orElseThrow(() -> new BuildException("Missing \"command\" key in storage while building: command"));
        Optional executor = storage.getString("executor");
        if (executor.isPresent() && ((String)executor.get()).equalsIgnoreCase("console")) {
            return new ConsoleCommandAction(this.plugin, command);
        }
        return new PlayerCommandAction(command);
    }
}

