/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.library.requirement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.onestorm.library.requirement.Requirement;
import net.onestorm.library.requirement.RequirementBuilder;
import net.onestorm.library.requirement.RequirementManager;
import net.onestorm.library.requirement.implementation.FallbackRequirement;
import net.onestorm.library.storage.StorageMap;

public class RequirementManagerImpl
implements RequirementManager {
    private final Map<String, RequirementBuilder> builderMap = new HashMap<String, RequirementBuilder>();
    private final Logger logger;

    public RequirementManagerImpl(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void registerBuilder(RequirementBuilder builder) {
        String name = builder.getName().toLowerCase(Locale.ENGLISH);
        if (this.builderMap.containsKey(name)) {
            throw new IllegalArgumentException("There already exists a builder with this name: " + name);
        }
        this.builderMap.put(name, builder);
    }

    @Override
    public void unregisterBuilder(RequirementBuilder builder) {
        String name = builder.getName().toLowerCase(Locale.ENGLISH);
        this.builderMap.remove(name);
    }

    @Override
    public List<Requirement> getRequirements(StorageMap storage) {
        ArrayList<Requirement> result = new ArrayList<Requirement>();
        storage.forEach((key, value) -> {
            Requirement requirement;
            if (!(value instanceof StorageMap)) {
                return;
            }
            StorageMap storageMap = (StorageMap)value;
            Optional optionalName = storageMap.getString("type");
            if (optionalName.isEmpty()) {
                this.logger.warning("Missing \"type\" key in configuration for Requirement: " + key);
                result.add(new FallbackRequirement());
                return;
            }
            String name = ((String)optionalName.get()).toLowerCase(Locale.ENGLISH);
            RequirementBuilder builder = this.builderMap.get(name);
            if (builder == null) {
                this.logger.warning("Could not find a builder for Requirement: " + name);
                result.add(new FallbackRequirement());
                return;
            }
            try {
                requirement = builder.build(storage);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Uncaught error while building a Requirement: " + name, e);
                result.add(new FallbackRequirement());
                return;
            }
            result.add(requirement);
        });
        return result;
    }
}

