/*
 * Decompiled with CFR 0.152.
 */
package net.onestorm.plugins.stormcombat.paper;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitScheduler;

public class StormCombat
extends JavaPlugin
implements Listener {
    private static final long COMBAT_TAG_TIME = 15L;
    private static final long CRYSTAL_TICKS_TO_LIVE = 10L;
    private final Map<EnderCrystal, Player> crystalMap = new ConcurrentHashMap<EnderCrystal, Player>();
    private final Map<UUID, ScheduledFuture<?>> taskMap = new ConcurrentHashMap();
    private final Set<UUID> tagged = new HashSet<UUID>();
    private ScheduledExecutorService executor;

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public void onDisable() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        Player player;
        TNTPrimed tnt;
        Player player2;
        AreaEffectCloud cloud;
        Player player3;
        Projectile projectile;
        ProjectileSource projectileSource;
        Entity damagerEntity = event.getDamager();
        Entity defenderEntity = event.getEntity();
        if (damagerEntity.getType() == EntityType.ENDER_PEARL || defenderEntity.getType() == EntityType.ENDER_PEARL) {
            return;
        }
        Player damager = null;
        if (damagerEntity instanceof Player) {
            Player player4;
            damager = player4 = (Player)damagerEntity;
        } else if (damagerEntity instanceof Projectile && (projectileSource = (projectile = (Projectile)damagerEntity).getShooter()) instanceof Player) {
            damager = player3 = (Player)projectileSource;
        } else if (damagerEntity instanceof AreaEffectCloud && (projectileSource = (cloud = (AreaEffectCloud)damagerEntity).getSource()) instanceof Player) {
            damager = player2 = (Player)projectileSource;
        } else if (damagerEntity instanceof TNTPrimed && (projectileSource = (tnt = (TNTPrimed)damagerEntity).getSource()) instanceof Player) {
            Player player5;
            damager = player5 = (Player)projectileSource;
        }
        Player defender = null;
        if (defenderEntity instanceof Player && !(player = (Player)defenderEntity).hasMetadata("NPC")) {
            defender = player;
        } else if (defenderEntity instanceof EnderCrystal) {
            EnderCrystal defenderCrystal = (EnderCrystal)defenderEntity;
            if (damager != null) {
                this.putCrystal(defenderCrystal, damager);
            } else if (damagerEntity instanceof EnderCrystal) {
                EnderCrystal damagerCrystal = (EnderCrystal)damagerEntity;
                player2 = this.crystalMap.get(damagerCrystal);
                if (player2 == null) {
                    return;
                }
                this.putCrystal(defenderCrystal, player2);
            }
        }
        if (damagerEntity instanceof EnderCrystal) {
            EnderCrystal damagerCrystal = (EnderCrystal)damagerEntity;
            player3 = this.crystalMap.get(damagerCrystal);
            if (player3 == null) {
                return;
            }
            damager = player3;
        }
        if (damager == null || defender == null || damager == defender) {
            return;
        }
        this.combatTag(damager);
        this.combatTag(defender);
    }

    private void putCrystal(EnderCrystal defender, Player damager) {
        this.crystalMap.put(defender, damager);
        BukkitScheduler scheduler = this.getServer().getScheduler();
        scheduler.scheduleSyncDelayedTask((Plugin)this, () -> this.crystalMap.remove(defender), 10L);
    }

    private void combatTag(Player player) {
        UUID uuid = player.getUniqueId();
        if (this.tagged.add(uuid)) {
            player.sendMessage((Component)Component.text((String)"[!] You are now combat tagged, do not leave!", (TextColor)NamedTextColor.RED));
        }
        BukkitScheduler scheduler = this.getServer().getScheduler();
        ScheduledFuture<?> future = this.executor.schedule(() -> scheduler.runTask((Plugin)this, () -> {
            if (this.tagged.remove(uuid)) {
                player.sendMessage((Component)Component.text((String)"[!] You are no longer in combat, you are free to leave!", (TextColor)NamedTextColor.GREEN));
            }
        }), 15L, TimeUnit.SECONDS);
        ScheduledFuture<?> oldFuture = this.taskMap.remove(uuid);
        if (oldFuture != null) {
            oldFuture.cancel(true);
        }
        this.taskMap.put(uuid, future);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.tagged.contains(uuid)) {
            event.setCancelled(true);
            player.sendMessage((Component)Component.text((String)"[!] You cannot use commands while combat tagged!", (TextColor)NamedTextColor.RED));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        ScheduledFuture<?> oldFuture = this.taskMap.remove(uuid);
        if (oldFuture != null) {
            oldFuture.cancel(true);
        }
        if (this.tagged.remove(uuid)) {
            player.sendMessage((Component)Component.text((String)"[!] You are no longer in combat, you are free to leave!", (TextColor)NamedTextColor.GREEN));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        ScheduledFuture<?> oldFuture = this.taskMap.remove(uuid);
        if (oldFuture != null) {
            oldFuture.cancel(true);
        }
        PlayerQuitEvent.QuitReason reason = event.getReason();
        if (this.tagged.remove(uuid) && reason != PlayerQuitEvent.QuitReason.KICKED) {
            player.setHealth(0.0);
            for (UUID taggedUuid : this.tagged) {
                Player taggedPlayer = this.getServer().getPlayer(taggedUuid);
                if (taggedPlayer == null) continue;
                taggedPlayer.sendMessage((Component)Component.text((String)(player.getName() + " was killed for leaving while combat tagged!"), (TextColor)NamedTextColor.RED));
            }
        }
    }
}

